/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ExternalLibraryManager
implements ILibraryManager {
    private final Map<String, ClassLoader> libraryClassLoaders = new HashMap<String, ClassLoader>();
    private final Map<String, List<String>> externalFunctionParameters = new HashMap<String, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLibraryClassLoader(String dataverseName, String libraryName, ClassLoader classLoader) throws RuntimeDataException {
        String key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        Map<String, ClassLoader> map = this.libraryClassLoaders;
        synchronized (map) {
            if (this.libraryClassLoaders.get(key) != null) {
                throw new RuntimeDataException(3044, new Serializable[0]);
            }
            this.libraryClassLoaders.put(key, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getAllLibraries() {
        ArrayList<Pair<String, String>> libs = new ArrayList<Pair<String, String>>();
        Map<String, ClassLoader> map = this.libraryClassLoaders;
        synchronized (map) {
            this.libraryClassLoaders.forEach((key, value) -> libs.add(ExternalLibraryManager.getDataverseAndLibararyName(key)));
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterLibraryClassLoader(String dataverseName, String libraryName) {
        String key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        Map<String, ClassLoader> map = this.libraryClassLoaders;
        synchronized (map) {
            if (this.libraryClassLoaders.get(key) != null) {
                this.libraryClassLoaders.remove(key);
            }
        }
    }

    public ClassLoader getLibraryClassLoader(String dataverseName, String libraryName) {
        String key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        return this.libraryClassLoaders.get(key);
    }

    public void addFunctionParameters(String dataverseName, String fullFunctionName, List<String> parameters) {
        this.externalFunctionParameters.put(dataverseName + "." + fullFunctionName, parameters);
    }

    public List<String> getFunctionParameters(String dataverseName, String fullFunctionName) {
        return this.externalFunctionParameters.getOrDefault(dataverseName + "." + fullFunctionName, Collections.emptyList());
    }

    private static String getKey(String dataverseName, String libraryName) {
        return dataverseName + "." + libraryName;
    }

    private static Pair<String, String> getDataverseAndLibararyName(String key) {
        int index = key.indexOf(46);
        String dataverse = key.substring(0, index);
        String library = key.substring(index + 1);
        return new Pair((Object)dataverse, (Object)library);
    }
}

