/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.ILookupReaderFactory;
import org.apache.asterix.external.api.ILookupRecordReader;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.input.record.reader.hdfs.RCLookupReader;
import org.apache.asterix.external.input.record.reader.hdfs.SequenceLookupReader;
import org.apache.asterix.external.input.record.reader.hdfs.TextLookupReader;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.hdfs.dataflow.ConfFactory;

public class HDFSLookupReaderFactory<T>
implements ILookupReaderFactory<T> {
    private static final long serialVersionUID = 1L;
    protected ConfFactory confFactory;
    protected Map<String, String> configuration;
    protected transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    protected transient IServiceContext serviceCtx;

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AsterixException {
        this.clusterLocations = HDFSUtils.getPartitionConstraints((IApplicationContext)this.serviceCtx.getApplicationContext(), this.clusterLocations);
        return this.clusterLocations;
    }

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration) throws AsterixException {
        this.serviceCtx = serviceCtx;
        this.configuration = configuration;
        JobConf conf = HDFSUtils.configureHDFSJobConf(configuration);
        try {
            this.confFactory = new ConfFactory(conf);
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public ILookupRecordReader<? extends T> createRecordReader(IHyracksTaskContext ctx, int partition, ExternalFileIndexAccessor snapshotAccessor) throws HyracksDataException {
        FileSystem fs;
        String inputFormatParameter = this.configuration.get("input-format").trim();
        JobConf conf = this.confFactory.getConf();
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new HyracksDataException("Unable to get filesystem object", (Throwable)e);
        }
        switch (inputFormatParameter) {
            case "text-input-format": {
                return new TextLookupReader(snapshotAccessor, fs, (Configuration)conf);
            }
            case "sequence-input-format": {
                return new SequenceLookupReader(snapshotAccessor, fs, (Configuration)conf);
            }
            case "rc-input-format": {
                return new RCLookupReader(snapshotAccessor, fs, (Configuration)conf);
            }
        }
        throw new HyracksDataException("Unrecognised input format: " + inputFormatParameter);
    }
}

