/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.dataflow.TupleForwarder;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedRecordDataFlowController<T>
extends AbstractFeedDataFlowController {
    public static final String INCOMING_RECORDS_COUNT_FIELD_NAME = "incoming-records-count";
    public static final String FAILED_AT_PARSER_RECORDS_COUNT_FIELD_NAME = "failed-at-parser-records-count";
    public static final String READER_STATS_FIELD_NAME = "reader-stats";
    private static final Logger LOGGER = LogManager.getLogger();
    private final IRecordDataParser<T> dataParser;
    private final IRecordReader<T> recordReader;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected static final long INTERVAL = 1000L;
    protected State state = State.CREATED;
    protected long incomingRecordsCount = 0L;
    protected long failedRecordsCount = 0L;

    public FeedRecordDataFlowController(IHyracksTaskContext ctx, FeedLogManager feedLogManager, int numOfOutputFields, IRecordDataParser<T> dataParser, IRecordReader<T> recordReader) throws HyracksDataException {
        super(ctx, feedLogManager, numOfOutputFields);
        this.dataParser = dataParser;
        this.recordReader = recordReader;
        recordReader.setFeedLogManager(feedLogManager);
        recordReader.setController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(IFrameWriter writer) throws HyracksDataException, InterruptedException {
        FeedRecordDataFlowController feedRecordDataFlowController = this;
        synchronized (feedRecordDataFlowController) {
            if (this.state == State.STOPPED) {
                return;
            }
            this.setState(State.STARTED);
        }
        Throwable failure = null;
        try {
            this.tupleForwarder = new TupleForwarder(this.ctx, writer);
            while (this.hasNext()) {
                IRawRecord<T> record = this.next();
                if (record == null) {
                    this.flush();
                    Thread.sleep(1000L);
                    continue;
                }
                this.tb.reset();
                ++this.incomingRecordsCount;
                if (this.parseAndForward(record)) continue;
                ++this.failedRecordsCount;
            }
        }
        catch (HyracksDataException e) {
            LOGGER.log(Level.WARN, "Exception during ingestion", (Throwable)e);
            if (e.getComponent() == "ASX" && e.getErrorCode() == 3110) {
                failure = e;
                try {
                    this.flush();
                }
                catch (Exception flushException) {
                    flushException.addSuppressed(e);
                    failure = flushException;
                }
            } else {
                failure = e;
            }
        }
        catch (Throwable e) {
            failure = e;
            LOGGER.log(Level.WARN, "Failure while operating a feed source", e);
        }
        finally {
            failure = this.finish(failure);
        }
        if (failure != null) {
            if (failure instanceof InterruptedException) {
                throw (InterruptedException)failure;
            }
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    private synchronized void setState(State newState) {
        LOGGER.log(Level.INFO, "State is being set from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        this.state = newState;
    }

    public synchronized State getState() {
        return this.state;
    }

    private IRawRecord<? extends T> next() throws Exception {
        try {
            return this.recordReader.next();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.flushing) {
                throw e;
            }
            if (!this.recordReader.handleException(e)) {
                throw new RuntimeDataException(3110, (Throwable)e, new Serializable[0]);
            }
            return null;
        }
    }

    private boolean hasNext() throws Exception {
        while (true) {
            try {
                return this.recordReader.hasNext();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (!this.flushing) continue;
                throw e;
                if (this.recordReader.handleException(e)) continue;
                throw new RuntimeDataException(3110, (Throwable)e, new Serializable[0]);
            }
            break;
        }
    }

    private Throwable finish(Throwable failure) {
        Throwable th = CleanupUtils.close(this.recordReader, (Throwable)failure);
        if (th == null) {
            try {
                this.tupleForwarder.complete();
            }
            catch (Throwable completeFailure) {
                th = completeFailure;
            }
        }
        this.closeSignal();
        this.setState(State.STOPPED);
        return th;
    }

    private boolean parseAndForward(IRawRecord<? extends T> record) throws IOException {
        try {
            this.dataParser.parse(record, this.tb.getDataOutput());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Parser failed to parse record", (Throwable)e);
            this.feedLogManager.logRecord(record.toString(), "Parser failed to parse record");
            return false;
        }
        this.tb.addFieldEndOffset();
        this.addMetaPart(this.tb, record);
        this.addPrimaryKeys(this.tb, record);
        this.tupleForwarder.addTuple(this.tb);
        return true;
    }

    protected void addMetaPart(ArrayTupleBuilder tb, IRawRecord<? extends T> record) throws IOException {
    }

    protected void addPrimaryKeys(ArrayTupleBuilder tb, IRawRecord<? extends T> record) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSignal() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            this.closed.set(true);
            this.closed.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSignal(long timeout) throws InterruptedException, HyracksDataException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be greater than 0");
        }
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            while (!this.closed.get()) {
                long before = System.currentTimeMillis();
                this.closed.wait(timeout);
                if (this.closed.get() || (timeout -= System.currentTimeMillis() - before) > 0L) continue;
                throw HyracksDataException.create((int)91, (Serializable[])new Serializable[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(long timeout) throws HyracksDataException {
        FeedRecordDataFlowController feedRecordDataFlowController = this;
        synchronized (feedRecordDataFlowController) {
            switch (this.state) {
                case CREATED: 
                case STOPPED: {
                    this.setState(State.STOPPED);
                    return true;
                }
                case STARTED: {
                    break;
                }
                default: {
                    throw new HyracksDataException("unknown state " + (Object)((Object)this.state));
                }
            }
        }
        if (this.recordReader.stop()) {
            try {
                this.waitForSignal(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public IRecordReader<T> getReader() {
        return this.recordReader;
    }

    public IRecordDataParser<T> getParser() {
        return this.dataParser;
    }

    @Override
    public String getStats() {
        String readerStats = this.recordReader.getStats();
        StringBuilder str = new StringBuilder();
        str.append("{");
        if (readerStats != null) {
            str.append("\"").append(READER_STATS_FIELD_NAME).append("\":").append(readerStats).append(", ");
        }
        str.append("\"").append(INCOMING_RECORDS_COUNT_FIELD_NAME).append("\": ").append(this.incomingRecordsCount).append(", \"").append(FAILED_AT_PARSER_RECORDS_COUNT_FIELD_NAME).append("\": ").append(this.failedRecordsCount).append("}");
        return str.toString();
    }

    public static enum State {
        CREATED,
        STARTED,
        STOPPED;

    }
}

