/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.adapter.factory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.api.IDataFlowController;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IDataSourceAdapter;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IIndexibleExternalDataSource;
import org.apache.asterix.external.api.IIndexingAdapterFactory;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.dataset.adapter.FeedAdapter;
import org.apache.asterix.external.dataset.adapter.GenericAdapter;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.parser.factory.ADMDataParserFactory;
import org.apache.asterix.external.provider.DataflowControllerProvider;
import org.apache.asterix.external.provider.DatasourceFactoryProvider;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.external.util.ExternalDataCompatibilityUtils;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericAdapterFactory
implements IIndexingAdapterFactory,
IAdapterFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private IExternalDataSourceFactory dataSourceFactory;
    private IDataParserFactory dataParserFactory;
    private ARecordType recordType;
    private Map<String, String> configuration;
    private List<ExternalFile> files;
    private boolean indexingOp;
    private boolean isFeed;
    private FileSplit[] feedLogFileSplits;
    private ARecordType metaType;
    private transient FeedLogManager feedLogManager;

    @Override
    public void setSnapshot(List<ExternalFile> files, boolean indexingOp) {
        this.files = files;
        this.indexingOp = indexingOp;
    }

    @Override
    public String getAlias() {
        return "adapter";
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        return this.dataSourceFactory.getPartitionConstraint();
    }

    @Override
    public synchronized IDataSourceAdapter createAdapter(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        INCServiceContext serviceCtx = ctx.getJobletContext().getServiceContext();
        INcApplicationContext appCtx = (INcApplicationContext)serviceCtx.getApplicationContext();
        try {
            this.restoreExternalObjects((IServiceContext)serviceCtx, appCtx.getLibraryManager());
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failure restoring external objects", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        if (this.isFeed) {
            if (this.feedLogManager == null) {
                this.feedLogManager = FeedUtils.getFeedLogManager(ctx, partition, this.feedLogFileSplits);
            }
            this.feedLogManager.touch();
        }
        IDataFlowController controller = DataflowControllerProvider.getDataflowController(this.recordType, ctx, partition, this.dataSourceFactory, this.dataParserFactory, this.configuration, this.indexingOp, this.isFeed, this.feedLogManager);
        if (this.isFeed) {
            return new FeedAdapter((AbstractFeedDataFlowController)controller);
        }
        return new GenericAdapter(controller);
    }

    private void restoreExternalObjects(IServiceContext serviceContext, ILibraryManager libraryManager) throws HyracksDataException, AlgebricksException {
        if (this.dataSourceFactory == null) {
            this.dataSourceFactory = DatasourceFactoryProvider.getExternalDataSourceFactory(libraryManager, this.configuration);
            if (this.dataSourceFactory.isIndexible() && this.files != null) {
                ((IIndexibleExternalDataSource)this.dataSourceFactory).setSnapshot(this.files, this.indexingOp);
            }
            this.dataSourceFactory.configure(serviceContext, this.configuration);
        }
        if (this.dataParserFactory == null) {
            this.dataParserFactory = ParserFactoryProvider.getDataParserFactory(libraryManager, this.configuration);
            this.dataParserFactory.setRecordType(this.recordType);
            this.dataParserFactory.setMetaType(this.metaType);
            this.dataParserFactory.configure(this.configuration);
        }
    }

    @Override
    public void configure(IServiceContext serviceContext, Map<String, String> configuration) throws HyracksDataException, AlgebricksException {
        this.configuration = configuration;
        IApplicationContext appCtx = (IApplicationContext)serviceContext.getApplicationContext();
        ExternalDataUtils.validateDataSourceParameters(configuration);
        this.dataSourceFactory = DatasourceFactoryProvider.getExternalDataSourceFactory(appCtx.getLibraryManager(), configuration);
        if (this.dataSourceFactory.isIndexible() && this.files != null) {
            ((IIndexibleExternalDataSource)this.dataSourceFactory).setSnapshot(this.files, this.indexingOp);
        }
        this.dataSourceFactory.configure(serviceContext, configuration);
        ExternalDataUtils.validateDataParserParameters(configuration);
        this.dataParserFactory = ParserFactoryProvider.getDataParserFactory(appCtx.getLibraryManager(), configuration);
        this.dataParserFactory.setRecordType(this.recordType);
        this.dataParserFactory.setMetaType(this.metaType);
        this.dataParserFactory.configure(configuration);
        ExternalDataCompatibilityUtils.validateCompatibility(this.dataSourceFactory, this.dataParserFactory);
        this.configureFeedLogManager(appCtx);
        this.nullifyExternalObjects();
    }

    private void configureFeedLogManager(IApplicationContext appCtx) throws HyracksDataException, AlgebricksException {
        this.isFeed = ExternalDataUtils.isFeed(this.configuration);
        if (this.isFeed) {
            this.feedLogFileSplits = FeedUtils.splitsForAdapter((ICcApplicationContext)appCtx, ExternalDataUtils.getDataverse(this.configuration), ExternalDataUtils.getFeedName(this.configuration), (AlgebricksPartitionConstraint)this.dataSourceFactory.getPartitionConstraint());
        }
    }

    private void nullifyExternalObjects() {
        if (ExternalDataUtils.isExternal(this.configuration.get("reader"))) {
            this.dataSourceFactory = null;
        }
        if (ExternalDataUtils.isExternal(this.configuration.get("parser"))) {
            this.dataParserFactory = null;
        }
    }

    @Override
    public ARecordType getOutputType() {
        return this.recordType;
    }

    @Override
    public void setOutputType(ARecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public ARecordType getMetaType() {
        return this.metaType;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
        this.metaType = metaType;
    }

    public IExternalDataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void configure(IExternalDataSourceFactory dataSourceFactory) throws AlgebricksException {
        this.dataSourceFactory = dataSourceFactory;
        this.dataParserFactory = new ADMDataParserFactory();
        this.dataParserFactory.setRecordType(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        this.dataParserFactory.configure(Collections.emptyMap());
        this.configuration = Collections.emptyMap();
    }
}

