/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.logging.RemoteLogRecord;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RemoteLogsNotifier
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PersistentLocalResourceRepository localResourceRep;
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private final LinkedBlockingQueue<RemoteLogRecord> remoteLogsQ;
    private final INcApplicationContext appCtx;

    public RemoteLogsNotifier(INcApplicationContext appCtx, LinkedBlockingQueue<RemoteLogRecord> remoteLogsQ) {
        this.appCtx = appCtx;
        this.remoteLogsQ = remoteLogsQ;
        this.localResourceRep = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
        this.indexCheckpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
    }

    @Override
    public void run() {
        String nodeId = this.appCtx.getServiceContext().getNodeId();
        Thread.currentThread().setName(nodeId + RemoteLogsNotifier.class.getSimpleName());
        block7: while (!Thread.currentThread().isInterrupted()) {
            try {
                RemoteLogRecord logRecord = this.remoteLogsQ.take();
                switch (logRecord.getLogType()) {
                    case 1: 
                    case 3: {
                        logRecord.getReplicationWorker().getChannel().socket().getOutputStream().write((nodeId + "$" + logRecord.getTxnId() + System.lineSeparator()).getBytes());
                        continue block7;
                    }
                    case 4: {
                        this.checkpointReplicaIndexes(logRecord, logRecord.getDatasetId());
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unexpected log type: " + logRecord.getLogType());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOGGER.error("Failed to process replicated log", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointReplicaIndexes(RemoteLogRecord remoteLogMapping, int datasetId) throws HyracksDataException {
        Set masterPartitions = this.appCtx.getReplicaManager().getPartitions();
        Predicate<LocalResource> replicaIndexesPredicate = lr -> {
            DatasetLocalResource dls = (DatasetLocalResource)lr.getResource();
            return dls.getDatasetId() == datasetId && !masterPartitions.contains(dls.getPartition());
        };
        Map resources = this.localResourceRep.getResources(replicaIndexesPredicate);
        List replicaIndexesRef = resources.values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
        for (DatasetResourceReference replicaIndexRef : replicaIndexesRef) {
            IIndexCheckpointManager indexCheckpointManager;
            IIndexCheckpointManager iIndexCheckpointManager = indexCheckpointManager = this.indexCheckpointManagerProvider.get((ResourceReference)replicaIndexRef);
            synchronized (iIndexCheckpointManager) {
                indexCheckpointManager.masterFlush(remoteLogMapping.getMasterLsn(), remoteLogMapping.getLSN());
            }
        }
    }
}

