/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.utils.DotFormatBuilder;
import org.apache.hyracks.algebricks.core.utils.LogicalOperatorDotVisitor;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobActivityGraph;
import org.apache.hyracks.api.job.JobSpecification;

public class DotFormatGenerator {
    private DotFormatGenerator() {
    }

    public static String generate(JobActivityGraph jobActivityGraph) {
        DotFormatBuilder.Node fromNode;
        String fromClassName;
        String fromFullClassName;
        IActivity activity;
        ActivityId fromActivityId;
        DotFormatBuilder.Node toNode;
        ActivityId toActivityId;
        String toClassName;
        String toFullClassName;
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of("JobActivityGraph"));
        HashSet<ImmutablePair> activitiesPairedSet = new HashSet<ImmutablePair>();
        Map activityMap = jobActivityGraph.getActivityMap();
        Map activityInputMap = jobActivityGraph.getActivityInputMap();
        Map activityOutputMap = jobActivityGraph.getActivityOutputMap();
        for (Map.Entry entry : activityMap.entrySet()) {
            ImmutablePair newPair;
            toFullClassName = ((IActivity)entry.getValue()).getClass().getName();
            toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
            toActivityId = ((IActivity)entry.getValue()).getActivityId();
            toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
            List connectors = (List)activityInputMap.get(entry.getKey());
            if (connectors != null) {
                for (IConnectorDescriptor connector : connectors) {
                    fromActivityId = jobActivityGraph.getProducerActivity(connector.getConnectorId());
                    activity = (IActivity)activityMap.get(fromActivityId);
                    fromFullClassName = activity.getClass().getName();
                    fromClassName = fromFullClassName.substring(fromFullClassName.lastIndexOf(46) + 1);
                    fromNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(fromActivityId.toString()), DotFormatBuilder.StringValue.of(fromActivityId.toString() + "-" + fromClassName));
                    newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                    if (activitiesPairedSet.contains(newPair)) continue;
                    activitiesPairedSet.add(newPair);
                    graphBuilder.createEdge(fromNode, toNode);
                }
            }
            fromActivityId = toActivityId;
            fromNode = toNode;
            connectors = (List)activityOutputMap.get(entry.getKey());
            if (connectors == null) continue;
            for (IConnectorDescriptor connector : connectors) {
                toActivityId = jobActivityGraph.getConsumerActivity(connector.getConnectorId());
                activity = (IActivity)activityMap.get(toActivityId);
                toFullClassName = activity.getClass().getName();
                toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
                toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
                newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                if (activitiesPairedSet.contains(newPair)) continue;
                activitiesPairedSet.add(newPair);
                graphBuilder.createEdge(fromNode, toNode);
            }
        }
        Map blocked2BlockerMap = jobActivityGraph.getBlocked2BlockerMap();
        for (Map.Entry entry : blocked2BlockerMap.entrySet()) {
            IActivity blockedActivity = (IActivity)activityMap.get(entry.getKey());
            toFullClassName = blockedActivity.getClass().getName();
            toClassName = toFullClassName.substring(toFullClassName.lastIndexOf(46) + 1);
            toActivityId = (ActivityId)entry.getKey();
            toNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(toActivityId.toString()), DotFormatBuilder.StringValue.of(toActivityId.toString() + "-" + toClassName));
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                ActivityId blockingActivityId;
                fromActivityId = blockingActivityId = (ActivityId)iterator.next();
                activity = (IActivity)activityMap.get(fromActivityId);
                fromFullClassName = activity.getClass().getName();
                fromClassName = fromFullClassName.substring(fromFullClassName.lastIndexOf(46) + 1);
                fromNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(fromActivityId.toString()), DotFormatBuilder.StringValue.of(fromActivityId.toString() + "-" + fromClassName));
                ImmutablePair newPair = new ImmutablePair((Object)fromActivityId, (Object)toActivityId);
                if (activitiesPairedSet.contains(newPair)) continue;
                activitiesPairedSet.add(newPair);
                graphBuilder.createEdge(fromNode, toNode).setColor(DotFormatBuilder.Color.RED);
            }
        }
        return graphBuilder.getDotDocument();
    }

    public static String generate(JobSpecification jobSpecification) {
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of("JobSpecification"));
        Map connectorMap = jobSpecification.getConnectorMap();
        Map cOp = jobSpecification.getConnectorOperatorMap();
        for (Map.Entry entry : cOp.entrySet()) {
            ConnectorDescriptorId connectorId = (ConnectorDescriptorId)entry.getKey();
            IConnectorDescriptor connector = (IConnectorDescriptor)connectorMap.get(connectorId);
            String edgeLabel = connector.getClass().getName().substring(connector.getClass().getName().lastIndexOf(".") + 1);
            edgeLabel = edgeLabel + "-" + connectorId;
            IOperatorDescriptor leftOperator = (IOperatorDescriptor)((Pair)((Pair)entry.getValue()).getLeft()).getLeft();
            IOperatorDescriptor rightOperator = (IOperatorDescriptor)((Pair)((Pair)entry.getValue()).getRight()).getLeft();
            String source = leftOperator.getClass().getName().substring(leftOperator.getClass().getName().lastIndexOf(".") + 1);
            DotFormatBuilder.Node sourceNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(leftOperator.getOperatorId().toString()), DotFormatBuilder.StringValue.of(leftOperator.toString() + "-" + source));
            String destination = rightOperator.getClass().getName().substring(rightOperator.getClass().getName().lastIndexOf(".") + 1);
            DotFormatBuilder.Node destinationNode = graphBuilder.createNode(DotFormatBuilder.StringValue.of(rightOperator.getOperatorId().toString()), DotFormatBuilder.StringValue.of(rightOperator.toString() + "-" + destination));
            graphBuilder.createEdge(sourceNode, destinationNode).setLabel(DotFormatBuilder.StringValue.of(edgeLabel));
        }
        return graphBuilder.getDotDocument();
    }

    public static String generate(ILogicalPlan plan, LogicalOperatorDotVisitor dotVisitor) throws AlgebricksException {
        DotFormatBuilder graphBuilder = new DotFormatBuilder(DotFormatBuilder.StringValue.of("Plan"));
        ILogicalOperator root = (ILogicalOperator)plan.getRoots().get(0).getValue();
        DotFormatGenerator.generateNode(graphBuilder, root, dotVisitor, new HashSet<ILogicalOperator>());
        return graphBuilder.getDotDocument();
    }

    public static void generateNode(DotFormatBuilder dotBuilder, ILogicalOperator op, LogicalOperatorDotVisitor dotVisitor, Set<ILogicalOperator> operatorsVisited) throws AlgebricksException {
        DotFormatBuilder.Node sourceNode;
        DotFormatBuilder.StringValue sourceNodeLabel;
        DotFormatBuilder.StringValue destinationNodeLabel = DotFormatGenerator.formatStringOf(op, dotVisitor);
        DotFormatBuilder.Node destinationNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of(Integer.toString(op.hashCode())), destinationNodeLabel);
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            sourceNodeLabel = DotFormatGenerator.formatStringOf((ILogicalOperator)mutable.getValue(), dotVisitor);
            sourceNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of(Integer.toString(((ILogicalOperator)mutable.getValue()).hashCode())), sourceNodeLabel);
            dotBuilder.createEdge(sourceNode, destinationNode);
            if (operatorsVisited.contains(mutable.getValue())) continue;
            DotFormatGenerator.generateNode(dotBuilder, (ILogicalOperator)mutable.getValue(), dotVisitor, operatorsVisited);
        }
        if (((AbstractLogicalOperator)op).hasNestedPlans()) {
            for (ILogicalPlan nestedPlan : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                ILogicalOperator nestedOperator = (ILogicalOperator)nestedPlan.getRoots().get(0).getValue();
                sourceNodeLabel = DotFormatGenerator.formatStringOf(nestedOperator, dotVisitor);
                sourceNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of(Integer.toString(nestedOperator.hashCode())), sourceNodeLabel);
                dotBuilder.createEdge(sourceNode, destinationNode).setLabel(DotFormatBuilder.StringValue.of("subplan"));
                if (operatorsVisited.contains(nestedOperator)) continue;
                DotFormatGenerator.generateNode(dotBuilder, nestedOperator, dotVisitor, operatorsVisited);
            }
        }
        if (!(op instanceof ExchangeOperator)) {
            destinationNode.setFillColor(DotFormatBuilder.Color.SKYBLUE);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.REPLICATE || op.getOperatorTag() == LogicalOperatorTag.SPLIT) {
            AbstractReplicateOperator replicateOperator = (AbstractReplicateOperator)op;
            sourceNode = destinationNode;
            for (int i = 0; i < replicateOperator.getOutputs().size(); ++i) {
                ILogicalOperator iLogicalOperator = (ILogicalOperator)replicateOperator.getOutputs().get(i).getValue();
                destinationNodeLabel = DotFormatGenerator.formatStringOf(iLogicalOperator, dotVisitor);
                destinationNode = dotBuilder.createNode(DotFormatBuilder.StringValue.of(Integer.toString(iLogicalOperator.hashCode())), destinationNodeLabel);
                if (replicateOperator.getOutputMaterializationFlags()[i]) {
                    dotBuilder.createEdge(sourceNode, destinationNode).setColor(DotFormatBuilder.Color.RED);
                    continue;
                }
                dotBuilder.createEdge(sourceNode, destinationNode);
            }
        }
        operatorsVisited.add(op);
    }

    private static DotFormatBuilder.StringValue formatStringOf(ILogicalOperator operator, LogicalOperatorDotVisitor dotVisitor) throws AlgebricksException {
        String formattedString = operator.accept(dotVisitor, null).trim();
        IPhysicalOperator physicalOperator = ((AbstractLogicalOperator)operator).getPhysicalOperator();
        formattedString = physicalOperator != null ? formattedString + "\\n" + physicalOperator.toString().trim() + " |" + (Object)((Object)operator.getExecutionMode()) + "|" : formattedString + "\\n|" + (Object)((Object)operator.getExecutionMode()) + "|";
        return DotFormatBuilder.StringValue.of(formattedString);
    }
}

