/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PropertiesUtil;

public class OrderedPartitionedProperty
implements IPartitioningProperty {
    private final List<OrderColumn> orderColumns;
    private INodeDomain domain;

    public OrderedPartitionedProperty(List<OrderColumn> orderColumns, INodeDomain domain) {
        this.domain = domain;
        this.orderColumns = orderColumns;
    }

    public List<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }

    public List<LogicalVariable> getColumns() {
        ArrayList<LogicalVariable> cols = new ArrayList<LogicalVariable>(this.orderColumns.size());
        for (OrderColumn oc : this.orderColumns) {
            cols.add(oc.getColumn());
        }
        return cols;
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED;
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.orderColumns;
    }

    @Override
    public IPartitioningProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        List<OrderColumn> columns = PropertiesUtil.replaceOrderColumnsByEqClasses(this.orderColumns, equivalenceClasses);
        columns = PropertiesUtil.applyFDsToOrderColumns(columns, fds);
        return new OrderedPartitionedProperty(columns, this.domain);
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        for (OrderColumn oc : this.orderColumns) {
            columns.add(oc.getColumn());
        }
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }

    @Override
    public void substituteColumnVars(Map<LogicalVariable, LogicalVariable> varMap) {
        for (OrderColumn orderColumn : this.orderColumns) {
            if (!varMap.containsKey(orderColumn.getColumn())) continue;
            orderColumn.setColumn(varMap.get(orderColumn.getColumn()));
        }
    }

    @Override
    public IPartitioningProperty clonePartitioningProperty() {
        return new OrderedPartitionedProperty(new ArrayList<OrderColumn>(this.orderColumns), this.domain);
    }
}

