/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;

public final class LocalOrderProperty
implements ILocalStructuralProperty {
    private List<OrderColumn> orderColumns;

    public LocalOrderProperty(List<OrderColumn> orderColumn) {
        this.orderColumns = orderColumn;
    }

    public List<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }

    public void setOrderColumns(List<OrderColumn> orderColumn) {
        this.orderColumns = orderColumn;
    }

    public List<LogicalVariable> getColumns() {
        ArrayList<LogicalVariable> orderVars = new ArrayList<LogicalVariable>();
        for (OrderColumn oc : this.orderColumns) {
            orderVars.add(oc.getColumn());
        }
        return orderVars;
    }

    public List<OrderOperator.IOrder.OrderKind> getOrders() {
        ArrayList<OrderOperator.IOrder.OrderKind> orderKinds = new ArrayList<OrderOperator.IOrder.OrderKind>();
        for (OrderColumn oc : this.orderColumns) {
            orderKinds.add(oc.getOrder());
        }
        return orderKinds;
    }

    @Override
    public ILocalStructuralProperty.PropertyType getPropertyType() {
        return ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY;
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        columns.addAll(this.getColumns());
    }

    public String toString() {
        return this.orderColumns.toString();
    }

    @Override
    public void getVariables(Collection<LogicalVariable> variables) {
        variables.addAll(this.getColumns());
    }

    public int hashCode() {
        return this.orderColumns.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LocalOrderProperty) {
            LocalOrderProperty lop = (LocalOrderProperty)object;
            return this.orderColumns.equals(lop.orderColumns);
        }
        return false;
    }

    @Override
    public ILocalStructuralProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        List<OrderColumn> normalizedOrderColumns = this.normalizeOrderingColumns(this.orderColumns, equivalenceClasses);
        this.reduceOrderingColumns(normalizedOrderColumns, fds);
        return new LocalOrderProperty(normalizedOrderColumns);
    }

    public boolean implies(ILocalStructuralProperty required) {
        if (required.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
            return false;
        }
        LocalOrderProperty requiredOrderProperty = (LocalOrderProperty)required;
        Iterator<OrderColumn> requiredColumnIterator = requiredOrderProperty.getOrderColumns().iterator();
        Iterator<OrderColumn> currentColumnIterator = this.orderColumns.iterator();
        return this.isPrefixOf(requiredColumnIterator, currentColumnIterator);
    }

    private <T> boolean isPrefixOf(Iterator<T> requiredColumnIterator, Iterator<T> currentColumnIterator) {
        while (requiredColumnIterator.hasNext()) {
            T oc = requiredColumnIterator.next();
            if (!currentColumnIterator.hasNext()) {
                return false;
            }
            if (oc.equals(currentColumnIterator.next())) continue;
            return false;
        }
        return true;
    }

    private List<OrderColumn> normalizeOrderingColumns(List<OrderColumn> inputOrderColumns, Map<LogicalVariable, EquivalenceClass> equivalenceClasses) {
        ArrayList<OrderColumn> newOrderColumns = new ArrayList<OrderColumn>();
        if (equivalenceClasses == null || equivalenceClasses.isEmpty()) {
            newOrderColumns.addAll(inputOrderColumns);
            return newOrderColumns;
        }
        for (OrderColumn oc : inputOrderColumns) {
            LogicalVariable v = oc.getColumn();
            EquivalenceClass ec = equivalenceClasses.get(v);
            if (ec == null) {
                newOrderColumns.add(new OrderColumn(v, oc.getOrder()));
                continue;
            }
            if (ec.representativeIsConst()) continue;
            newOrderColumns.add(new OrderColumn(ec.getVariableRepresentative(), oc.getOrder()));
        }
        return newOrderColumns;
    }

    private void reduceOrderingColumns(List<OrderColumn> inputOrderColumns, List<FunctionalDependency> fds) {
        if (fds == null || fds.isEmpty()) {
            return;
        }
        HashSet<OrderColumn> impliedColumns = new HashSet<OrderColumn>();
        HashSet<LogicalVariable> currentPrefix = new HashSet<LogicalVariable>();
        for (OrderColumn orderColumn : inputOrderColumns) {
            LogicalVariable orderVariable = orderColumn.getColumn();
            for (FunctionalDependency fdep : fds) {
                if (!currentPrefix.containsAll(fdep.getHead()) || !fdep.getTail().contains(orderVariable)) continue;
                impliedColumns.add(orderColumn);
                break;
            }
            currentPrefix.add(orderVariable);
        }
        inputOrderColumns.removeAll(impliedColumns);
    }

    @Override
    public ILocalStructuralProperty retainVariables(Collection<LogicalVariable> vars) {
        List<LogicalVariable> columns = this.getColumns();
        ArrayList<LogicalVariable> newVars = new ArrayList<LogicalVariable>();
        newVars.addAll(vars);
        newVars.retainAll(columns);
        ArrayList<OrderColumn> newColumns = new ArrayList<OrderColumn>();
        for (OrderColumn oc : this.orderColumns) {
            if (!newVars.contains(oc.getColumn())) break;
            newColumns.add(oc);
        }
        if (!newColumns.isEmpty()) {
            return new LocalOrderProperty(newColumns);
        }
        return null;
    }

    @Override
    public ILocalStructuralProperty regardToGroup(Collection<LogicalVariable> groupKeys) {
        ArrayList<OrderColumn> newColumns = new ArrayList<OrderColumn>();
        for (OrderColumn oc : this.orderColumns) {
            if (groupKeys.contains(oc.getColumn())) continue;
            newColumns.add(oc);
        }
        if (!newColumns.isEmpty()) {
            return new LocalOrderProperty(newColumns);
        }
        return null;
    }
}

