/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AbstractLogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;

public class LogicalOperatorPrettyPrintVisitorJson
extends AbstractLogicalOperatorPrettyPrintVisitor {
    Map<AbstractLogicalOperator, String> operatorIdentity = new HashMap<AbstractLogicalOperator, String>();
    IdCounter idCounter = new IdCounter();

    public LogicalOperatorPrettyPrintVisitorJson(Appendable app) {
        super(app);
    }

    @Override
    public void printOperator(AbstractLogicalOperator op, int indent) throws AlgebricksException {
        int currentIndent = indent;
        AlgebricksAppendable out = this.get();
        LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent);
        LogicalOperatorPrettyPrintVisitorJson.appendln(out, "{");
        op.accept(this, ++currentIndent);
        LogicalOperatorPrettyPrintVisitorJson.appendln(out, ",");
        LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent);
        LogicalOperatorPrettyPrintVisitorJson.append(out, "\"operatorId\": \"" + this.idCounter.printOperatorId(op) + "\"");
        IPhysicalOperator pOp = op.getPhysicalOperator();
        if (pOp != null) {
            LogicalOperatorPrettyPrintVisitorJson.appendln(out, ",");
            LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent);
            String pOperator = "\"physical-operator\": \"" + pOp.toString() + "\"";
            LogicalOperatorPrettyPrintVisitorJson.append(out, pOperator);
        }
        LogicalOperatorPrettyPrintVisitorJson.appendln(out, ",");
        LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent);
        LogicalOperatorPrettyPrintVisitorJson.append(out, "\"execution-mode\": \"" + (Object)((Object)op.getExecutionMode()) + '\"');
        if (!op.getInputs().isEmpty()) {
            LogicalOperatorPrettyPrintVisitorJson.appendln(out, ",");
            LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent);
            LogicalOperatorPrettyPrintVisitorJson.appendln(out, "\"inputs\": [");
            boolean moreInputes = false;
            for (Mutable<ILogicalOperator> k : op.getInputs()) {
                if (moreInputes) {
                    LogicalOperatorPrettyPrintVisitorJson.append(out, ",");
                }
                this.printOperator((AbstractLogicalOperator)k.getValue(), currentIndent + 4);
                moreInputes = true;
            }
            LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent + 2);
            LogicalOperatorPrettyPrintVisitorJson.appendln(out, "]");
        } else {
            out.append("\n");
        }
        LogicalOperatorPrettyPrintVisitorJson.pad(out, currentIndent - 1);
        LogicalOperatorPrettyPrintVisitorJson.appendln(out, "}");
    }

    public void variablePrintHelper(List<LogicalVariable> variables, Integer indent) throws AlgebricksException {
        if (!variables.isEmpty()) {
            this.addIndent(0).append(",\n");
            this.addIndent(indent).append("\"variables\": [");
            this.appendVars(variables);
            this.buffer.append("]");
        }
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"aggregate\"");
        this.variablePrintHelper(op.getVariables(), indent);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"running-aggregate\"");
        this.variablePrintHelper(op.getVariables(), indent);
        if (!op.getExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"empty-tuple-source\"");
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"group-by\"");
        if (op.isGroupAll()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"option\": \"all\"");
        }
        if (!op.getGroupByList().isEmpty()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"group-by-list\": ");
            this.pprintVeList(op.getGroupByList(), indent);
        }
        if (!op.getDecorList().isEmpty()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"decor-list\": ");
            this.pprintVeList(op.getDecorList(), indent);
        }
        if (!op.getNestedPlans().isEmpty()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"subplan\": ");
            this.printNestedPlans(op, indent);
        }
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"distinct\"");
        if (!op.getExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"join\",\n");
        this.addIndent(indent).append("\"condition\": \"" + (String)((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent) + "\"");
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"left-outer-join\",\n");
        this.addIndent(indent).append("\"condition\": \"" + (String)((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent) + "\"");
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"nested-tuple-source\"");
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"order\"");
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getOrderExpressions()) {
            this.buffer.append(",\n");
            if (op.getTopK() != -1) {
                this.addIndent(indent).append("\"topK\": \"" + op.getTopK() + "\",\n");
            }
            String fst = this.getOrderString((OrderOperator.IOrder)p.first);
            this.addIndent(indent).append("\"first\": " + fst + ",\n");
            this.addIndent(indent).append("\"second\": \"" + ((String)((ILogicalExpression)((Mutable)p.second).getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        }
        return null;
    }

    private String getOrderString(OrderOperator.IOrder first) {
        switch (first.getKind()) {
            case ASC: {
                return "\"ASC\"";
            }
            case DESC: {
                return "\"DESC\"";
            }
        }
        return first.getExpressionRef().toString();
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"assign\"");
        this.variablePrintHelper(op.getVariables(), indent);
        if (!op.getExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"write\"");
        if (!op.getExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"distribute-result\"");
        if (!op.getExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"load\",\n");
        this.addIndent(indent).append(this.str(op.getDataSource())).append("\"from\":").append((String)((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent) + ",\n");
        this.addIndent(indent).append("\"partitioned-by\": {");
        this.pprintExprList(op.getKeyExpressions(), indent);
        this.addIndent(indent).append("}");
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"select\",\n");
        this.addIndent(indent).append("\"expressions\": \"" + ((String)((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"project\"");
        this.variablePrintHelper(op.getVariables(), indent);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Integer indent) throws AlgebricksException {
        if (!op.getNestedPlans().isEmpty()) {
            this.addIndent(indent).append("\"subplan\": ");
            this.printNestedPlans(op, indent);
        }
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"union\"");
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"values\": [\"" + v.first + "\",\"" + v.second + "\",\"" + v.third + "\"]");
        }
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"intersect\",\n");
        this.addIndent(indent).append("\"output-variables\": [");
        this.appendVars(op.getOutputVars());
        this.buffer.append("],");
        this.addIndent(indent).append("\"input_variables\": [");
        for (int i = 0; i < op.getNumInput(); ++i) {
            if (i > 0) {
                this.buffer.append(",\n");
            }
            this.appendVars(op.getInputVariables(i));
        }
        this.buffer.append("]");
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"unnest\"");
        this.variablePrintHelper(op.getVariables(), indent);
        if (op.getPositionalVariable() != null) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"position\": \"" + op.getPositionalVariable() + "\"");
        }
        this.buffer.append(",\n");
        this.addIndent(indent).append("\"expressions\": \"" + ((String)((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"outer-unnest\",\n");
        this.addIndent(indent).append("\"variables\": [\"" + op.getVariable() + "\"]");
        if (op.getPositionalVariable() != null) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"position\": " + op.getPositionalVariable());
        }
        this.buffer.append(",\n");
        this.addIndent(indent).append("\"expressions\": \"" + ((String)((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Integer indent) throws AlgebricksException {
        AlgebricksAppendable plan = this.printAbstractUnnestMapOperator(op, indent, "unnest-map");
        this.appendSelectConditionInformation(plan, op.getSelectCondition(), indent);
        this.appendLimitInformation(plan, op.getOutputLimit(), indent);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Integer indent) throws AlgebricksException {
        this.printAbstractUnnestMapOperator(op, indent, "left-outer-unnest-map");
        return null;
    }

    private AlgebricksAppendable printAbstractUnnestMapOperator(AbstractUnnestMapOperator op, Integer indent, String opSignature) throws AlgebricksException {
        AlgebricksAppendable plan = this.addIndent(indent).append("\"operator\": \"" + opSignature + "\"");
        this.variablePrintHelper(op.getVariables(), indent);
        this.buffer.append(",\n");
        this.addIndent(indent).append("\"expressions\": \"" + ((String)((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        this.appendFilterInformation(plan, op.getMinFilterVars(), op.getMaxFilterVars(), indent);
        return plan;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Integer indent) throws AlgebricksException {
        AlgebricksAppendable plan = this.addIndent(indent).append("\"operator\": \"data-scan\"");
        if (!op.getProjectVariables().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.addIndent(indent).append("\"project-variables\": [");
            this.appendVars(op.getProjectVariables());
            this.buffer.append("]");
        }
        this.variablePrintHelper(op.getVariables(), indent);
        if (op.getDataSource() != null) {
            this.addIndent(0).append(",\n");
            this.addIndent(indent).append("\"data-source\": \"" + op.getDataSource() + "\"");
        }
        this.appendFilterInformation(plan, op.getMinFilterVars(), op.getMaxFilterVars(), indent);
        this.appendSelectConditionInformation(plan, op.getSelectCondition(), indent);
        this.appendLimitInformation(plan, op.getOutputLimit(), indent);
        return null;
    }

    private Void appendFilterInformation(AlgebricksAppendable plan, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, Integer indent) throws AlgebricksException {
        if (minFilterVars != null || maxFilterVars != null) {
            plan.append(",\n");
            this.addIndent(indent);
            plan.append("\"with-filter-on\": {");
        }
        if (minFilterVars != null) {
            this.buffer.append("\n");
            this.addIndent(indent).append("\"min\": [");
            this.appendVars(minFilterVars);
            this.buffer.append("]");
        }
        if (minFilterVars != null && maxFilterVars != null) {
            this.buffer.append(",");
        }
        if (maxFilterVars != null) {
            this.buffer.append("\n");
            this.addIndent(indent).append("\"max\": [");
            this.appendVars(maxFilterVars);
            this.buffer.append("]");
        }
        if (minFilterVars != null || maxFilterVars != null) {
            plan.append("\n");
            this.addIndent(indent).append("}");
        }
        return null;
    }

    private Void appendSelectConditionInformation(AlgebricksAppendable plan, Mutable<ILogicalExpression> condition, Integer indent) throws AlgebricksException {
        if (condition != null) {
            plan.append(",\n");
            this.addIndent(indent).append("\"condition\": \"" + ((String)((ILogicalExpression)condition.getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        }
        return null;
    }

    private Void appendLimitInformation(AlgebricksAppendable plan, long outputLimit, Integer indent) throws AlgebricksException {
        if (outputLimit >= 0L) {
            plan.append(",\n");
            this.addIndent(indent).append("\"limit\": \"" + outputLimit + "\"");
        }
        return null;
    }

    private void appendVars(List<LogicalVariable> minFilterVars) throws AlgebricksException {
        boolean first = true;
        for (LogicalVariable v : minFilterVars) {
            if (!first) {
                this.buffer.append(",");
            }
            this.buffer.append("\"" + this.str(v) + "\"");
            first = false;
        }
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"limit\",\n");
        this.addIndent(indent).append("\"value\": \"" + (String)((ILogicalExpression)op.getMaxObjects().getValue()).accept(this.exprVisitor, indent) + "\"");
        ILogicalExpression offset = (ILogicalExpression)op.getOffset().getValue();
        if (offset != null) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"offset\": \"" + (String)offset.accept(this.exprVisitor, indent) + "\"");
        }
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"exchange\"");
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"script\"");
        if (!op.getInputVariables().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.addIndent(indent).append("\"in\": [");
            this.appendVars(op.getInputVariables());
            this.buffer.append("]");
        }
        if (!op.getOutputVariables().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.addIndent(indent).append("\"out\": [");
            this.appendVars(op.getOutputVariables());
            this.buffer.append("]");
        }
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"replicate\"");
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Integer indent) throws AlgebricksException {
        Mutable<ILogicalExpression> branchingExpression = op.getBranchingExpression();
        this.addIndent(indent).append("\"operator\": \"split\",\n");
        this.addIndent(indent).append("\"expressions\": \"" + ((String)((ILogicalExpression)branchingExpression.getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"");
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"materialize\"");
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Integer indent) throws AlgebricksException {
        String header = "\"operator\": \"" + this.getIndexOpString(op.getOperation()) + "\",\n";
        this.addIndent(indent).append(header);
        this.addIndent(indent).append(this.str("\"data-source\": \"" + op.getDataSource() + "\",\n"));
        this.addIndent(indent).append("\"from-record\": \"").append((String)((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent) + "\"");
        if (op.getAdditionalNonFilteringExpressions() != null) {
            this.buffer.append(",\n\"meta\": {");
            this.pprintExprList(op.getAdditionalNonFilteringExpressions(), 0);
            this.buffer.append("}");
        }
        this.buffer.append(",\n");
        this.addIndent(indent).append("\"partitioned-by\": {");
        this.pprintExprList(op.getPrimaryKeyExpressions(), 0);
        this.buffer.append("}");
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.addIndent(indent).append(",\n\"out\": {\n");
            this.addIndent(indent).append("\"record-before-upsert\": \"" + op.getBeforeOpRecordVar() + "\"");
            if (op.getBeforeOpAdditionalNonFilteringVars() != null) {
                this.buffer.append(",\n");
                this.addIndent(indent).append("\"additional-before-upsert\": \"" + op.getBeforeOpAdditionalNonFilteringVars() + "\"");
            }
            this.addIndent(indent).append("}");
        }
        if (op.isBulkload()) {
            this.buffer.append(",\n");
            this.addIndent(indent).append("\"bulkload\": true");
        }
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Integer indent) throws AlgebricksException {
        String header = this.getIndexOpString(op.getOperation());
        this.addIndent(indent).append("\"operator\": \"" + header + "\",\n");
        this.addIndent(indent).append("\"index\": \"" + op.getIndexName() + "\",\n");
        this.addIndent(indent).append("\"on\": \"").append(this.str(op.getDataSourceIndex().getDataSource()) + "\",\n");
        this.addIndent(indent).append("\"from\": {");
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.addIndent(indent).append("[\"replace\": \"");
            this.pprintExprList(op.getPrevSecondaryKeyExprs(), 0);
            this.buffer.append("\",\n");
            this.addIndent(indent).append("\"with\": \"");
            this.pprintExprList(op.getSecondaryKeyExpressions(), 0);
            this.buffer.append("\"}");
        } else {
            this.pprintExprList(op.getSecondaryKeyExpressions(), 0);
        }
        this.buffer.append("\n");
        this.addIndent(indent).append("}");
        if (op.isBulkload()) {
            this.buffer.append(",\n");
            this.buffer.append("\"bulkload\": true");
        }
        return null;
    }

    public String getIndexOpString(InsertDeleteUpsertOperator.Kind opKind) {
        switch (opKind) {
            case DELETE: {
                return "delete-from";
            }
            case INSERT: {
                return "insert-into";
            }
            case UPSERT: {
                return "upsert-into";
            }
        }
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"tokenize\"");
        this.variablePrintHelper(op.getTokenizeVars(), indent);
        if (!op.getSecondaryKeyExpressions().isEmpty()) {
            this.addIndent(0).append(",\n");
            this.pprintExprList(op.getSecondaryKeyExpressions(), indent);
        }
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"sink\"");
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("\"operator\": \"" + op.toString() + "\"");
        return null;
    }

    protected void printNestedPlans(AbstractOperatorWithNestedPlans op, Integer indent) throws AlgebricksException {
        this.idCounter.nextPrefix();
        this.buffer.append("[\n");
        boolean first = true;
        for (ILogicalPlan p : op.getNestedPlans()) {
            if (!first) {
                this.buffer.append(",");
            }
            this.printPlan(p, indent + 4);
            first = false;
        }
        this.addIndent(indent).append("]");
        this.idCounter.previousPrefix();
    }

    protected void pprintExprList(List<Mutable<ILogicalExpression>> expressions, Integer indent) throws AlgebricksException {
        this.addIndent(indent);
        this.buffer.append("\"expressions\": \"");
        boolean first = true;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(", ");
            }
            this.buffer.append(((String)((ILogicalExpression)exprRef.getValue()).accept(this.exprVisitor, indent)).replace('\"', ' '));
        }
        this.buffer.append("\"");
    }

    protected void pprintVeList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> vePairList, Integer indent) throws AlgebricksException {
        this.buffer.append("[");
        boolean first = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : vePairList) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(",");
            }
            if (ve.first != null) {
                this.buffer.append("{\"variable\": \"" + ((LogicalVariable)ve.first).toString().replace('\"', ' ') + "\",\"expression\": \"" + ((Mutable)ve.second).toString().replace('\"', ' ') + "\"}");
                continue;
            }
            this.buffer.append("{\"expression\": \"" + ((String)((ILogicalExpression)((Mutable)ve.second).getValue()).accept(this.exprVisitor, indent)).replace('\"', ' ') + "\"}");
        }
        this.buffer.append("]");
    }

    public class IdCounter {
        private int id;
        private final Deque<Integer> prefix = new LinkedList<Integer>();

        public IdCounter() {
            this.prefix.add(1);
            this.id = 0;
        }

        public void previousPrefix() {
            this.id = this.prefix.removeLast();
        }

        public void nextPrefix() {
            this.prefix.add(this.id);
            this.id = 0;
        }

        public String printOperatorId(AbstractLogicalOperator op) {
            Object[] values;
            String stringPrefix = "";
            for (Object val : values = this.prefix.toArray()) {
                stringPrefix = stringPrefix.isEmpty() ? val.toString() : stringPrefix + "." + val.toString();
            }
            if (!LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.containsKey(op)) {
                String opId = stringPrefix.isEmpty() ? "" + Integer.toString(++this.id) : stringPrefix + "." + Integer.toString(++this.id);
                LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.put(op, opId);
            }
            return LogicalOperatorPrettyPrintVisitorJson.this.operatorIdentity.get(op);
        }
    }
}

