/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class UnionAllOperator
extends AbstractLogicalOperator {
    private List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap;

    public UnionAllOperator(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap) {
        this.varMap = varMap;
    }

    public List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> getVariableMappings() {
        return this.varMap;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.UNIONALL;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                for (Triple t : UnionAllOperator.this.varMap) {
                    target.addVariable((LogicalVariable)t.third);
                }
            }
        };
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitUnionOperator(this, arg);
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        for (LogicalVariable v1 : ((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema()) {
            for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
                if (((LogicalVariable)t.first).equals(v1)) {
                    this.schema.add(t.third);
                    continue;
                }
                this.schema.add(v1);
            }
        }
        for (LogicalVariable v2 : ((ILogicalOperator)((Mutable)this.inputs.get(1)).getValue()).getSchema()) {
            for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
                if (((LogicalVariable)t.second).equals(v2)) {
                    this.schema.add(t.third);
                    continue;
                }
                this.schema.add(v2);
            }
        }
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        IVariableTypeEnvironment envLeft = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        IVariableTypeEnvironment envRight = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(1)).getValue());
        if (envLeft == null) {
            throw new AlgebricksException("Left input types for union operator are not computed.");
        }
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
            Object typeFromRight;
            Object typeFromLeft = this.getType(envLeft, (LogicalVariable)t.first);
            if (typeFromLeft.equals(typeFromRight = this.getType(envRight, (LogicalVariable)t.second))) {
                env.setVarType((LogicalVariable)t.third, typeFromLeft);
                continue;
            }
            env.setVarType((LogicalVariable)t.third, ctx.getConflictingTypeResolver().resolve(typeFromLeft, typeFromRight));
        }
        return env;
    }

    private Object getType(IVariableTypeEnvironment env, LogicalVariable var) throws AlgebricksException {
        Object type = env.getVarType(var);
        if (type == null) {
            throw new AlgebricksException("Failed typing union operator: no type for variable " + var);
        }
        return type;
    }
}

