/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.control.common.job.profiling.OperatorStats;

public class StatsCollector
implements IStatsCollector {
    private static final long serialVersionUID = 6858817639895434577L;
    private final Map<String, IOperatorStats> operatorStatsMap = new HashMap<String, IOperatorStats>();

    public void add(IOperatorStats operatorStats) throws HyracksDataException {
        if (this.operatorStatsMap.containsKey(operatorStats.getName())) {
            throw new IllegalArgumentException("Operator with the same name already exists");
        }
        this.operatorStatsMap.put(operatorStats.getName(), operatorStats);
    }

    public IOperatorStats getOperatorStats(String operatorName) {
        return this.operatorStatsMap.get(operatorName);
    }

    public static StatsCollector create(DataInput input) throws IOException {
        StatsCollector statsCollector = new StatsCollector();
        statsCollector.readFields(input);
        return statsCollector;
    }

    public IOperatorStats getAggregatedStats() {
        OperatorStats aggregatedStats = new OperatorStats("aggregated");
        for (IOperatorStats stats : this.operatorStatsMap.values()) {
            aggregatedStats.getTupleCounter().update(stats.getTupleCounter().get());
            aggregatedStats.getTimeCounter().update(stats.getTupleCounter().get());
        }
        return aggregatedStats;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeInt(this.operatorStatsMap.size());
        for (IOperatorStats operatorStats : this.operatorStatsMap.values()) {
            operatorStats.writeFields(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        int operatorCount = input.readInt();
        for (int i = 0; i < operatorCount; ++i) {
            IOperatorStats opStats = OperatorStats.create(input);
            this.operatorStatsMap.put(opStats.getName(), opStats);
        }
    }
}

