/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.ArrayList;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.NoOpCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterResultPartitionLocationWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final boolean orderedResult;
    private final boolean emptyResult;
    private final int partition;
    private final int nPartitions;
    private final NetworkAddress networkAddress;

    public RegisterResultPartitionLocationWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, boolean orderedResult, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.orderedResult = orderedResult;
        this.emptyResult = emptyResult;
        this.partition = partition;
        this.nPartitions = nPartitions;
        this.networkAddress = networkAddress;
    }

    public void run() {
        block2: {
            try {
                this.ccs.getResultDirectoryService().registerResultPartitionLocation(this.jobId, this.rsId, this.orderedResult, this.emptyResult, this.partition, this.nPartitions, this.networkAddress);
            }
            catch (HyracksDataException e) {
                LOGGER.log(Level.WARN, "Failed to register partition location", (Throwable)e);
                JobRun jobRun = this.ccs.getJobManager().get(this.jobId);
                if (jobRun == null) break block2;
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                exceptions.add((Exception)((Object)e));
                jobRun.getExecutor().abortJob(exceptions, (IResultCallback<Void>)NoOpCallback.INSTANCE);
            }
        }
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " ResultSetId@" + this.rsId + " Partition@" + this.partition + " NPartitions@" + this.nPartitions + " ResultPartitionLocation@" + this.networkAddress + " OrderedResult@" + this.orderedResult + " EmptyResult@" + this.emptyResult;
    }
}

