/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationInstallationHandler
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private ClusterControllerService ccs;

    public ApplicationInstallationHandler(ConcurrentMap<String, Object> ctx, String[] paths, ClusterControllerService ccs) {
        super(ctx, paths);
        this.ccs = ccs;
    }

    public void handle(IServletRequest request, IServletResponse response) {
        String localPath = this.localPath(request);
        while (localPath.startsWith("/")) {
            localPath = localPath.substring(1);
        }
        String[] params = localPath.split("&");
        if (params.length != 2 || params[0].isEmpty() || params[1].isEmpty()) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String deployIdString = params[0];
        String fileName = params[1];
        String rootDir = this.ccs.getServerContext().getBaseDir().toString();
        String deploymentDir = rootDir.endsWith(File.separator) ? rootDir + "applications/" + deployIdString : rootDir + File.separator + "/applications/" + File.separator + deployIdString;
        HttpMethod method = request.getHttpRequest().method();
        try {
            response.setStatus(HttpResponseStatus.OK);
            if (method == HttpMethod.PUT) {
                ByteBuf content = request.getHttpRequest().content();
                this.writeToFile(content, deploymentDir, fileName);
            } else if (method == HttpMethod.GET) {
                this.readFromFile(fileName, deploymentDir, response);
            } else {
                response.setStatus(HttpResponseStatus.METHOD_NOT_ALLOWED);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Unhandled exception ", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromFile(final String fileName, final String deploymentDir, IServletResponse response) throws Exception {
        class InputStreamGetter
        extends SynchronizableWork {
            private InputStream is;

            InputStreamGetter() {
            }

            protected void doRun() throws Exception {
                File jarFile = new File(deploymentDir, fileName);
                this.is = new FileInputStream(jarFile);
            }
        }
        InputStreamGetter r = new InputStreamGetter();
        this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)r);
        if (r.is == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        } else {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/octet-stream");
            response.setStatus(HttpResponseStatus.OK);
            try {
                IOUtils.copyLarge((InputStream)r.is, (OutputStream)response.outputStream());
            }
            finally {
                r.is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(ByteBuf content, final String deploymentDir, final String fileName) throws Exception {
        class OutputStreamGetter
        extends SynchronizableWork {
            private OutputStream os;

            OutputStreamGetter() {
            }

            protected void doRun() throws Exception {
                FileUtils.forceMkdir((File)new File(deploymentDir));
                File jarFile = new File(deploymentDir, fileName);
                this.os = new FileOutputStream(jarFile);
            }
        }
        OutputStreamGetter r = new OutputStreamGetter();
        this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)r);
        try {
            content.getBytes(0, r.os, content.readableBytes());
        }
        finally {
            r.os.close();
        }
    }
}

