/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.frames;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.frames.OrderedSlotManager;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.common.api.ISlotManager;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.frames.TreeIndexNSMFrame;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public class BTreeNSMLeafFrame
extends TreeIndexNSMFrame
implements IBTreeLeafFrame {
    protected static final int NEXT_LEAF_OFFSET = 22;
    private MultiComparator cmp;
    private final ITreeIndexTupleReference previousFt;

    public BTreeNSMLeafFrame(ITreeIndexTupleWriter tupleWriter) {
        super(tupleWriter, (ISlotManager)new OrderedSlotManager());
        this.previousFt = tupleWriter.createTupleReference();
    }

    public int getPageHeaderSize() {
        return 26;
    }

    public int getBytesRequiredToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + this.slotManager.getSlotSize();
    }

    public void initBuffer(byte level) {
        super.initBuffer(level);
        this.buf.putInt(22, -1);
    }

    @Override
    public void setNextLeaf(int page) {
        this.buf.putInt(22, page);
    }

    @Override
    public int getNextLeaf() {
        return this.buf.getInt(22);
    }

    @Override
    public int findInsertTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw HyracksDataException.create((int)33, (Serializable[])new Serializable[0]);
        }
        return tupleIndex;
    }

    @Override
    public int findUpdateTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator() || tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            throw HyracksDataException.create((int)37, (Serializable[])new Serializable[0]);
        }
        return tupleIndex;
    }

    @Override
    public int findUpsertTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.INCLUSIVE, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        return tupleIndex;
    }

    @Override
    public ITupleReference getMatchingKeyTuple(ITupleReference searchTuple, int targetTupleIndex) throws HyracksDataException {
        if (targetTupleIndex != this.slotManager.getGreatestKeyIndicator()) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, targetTupleIndex);
            if (this.cmp.compare(searchTuple, (ITupleReference)this.frameTuple) == 0) {
                return this.frameTuple;
            }
        }
        return null;
    }

    @Override
    public int findDeleteTupleIndex(ITupleReference tuple) throws HyracksDataException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator() || tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            throw HyracksDataException.create((int)37, (Serializable[])new Serializable[0]);
        }
        return tupleIndex;
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        int freeSpace = this.buf.getInt(4);
        this.slotManager.insertSlot(tupleIndex, freeSpace);
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), freeSpace);
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + bytesWritten);
        this.buf.putInt(17, this.buf.getInt(17) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void insertSorted(ITupleReference tuple) {
        this.insert(tuple, this.slotManager.getGreatestKeyIndicator());
    }

    boolean isLargeTuple(int tupleSize) {
        return tupleSize > this.getMaxTupleSize(this.page.getPageSize());
    }

    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) throws HyracksDataException {
        int tupleSize = this.getBytesRequiredToWriteTuple(tuple);
        if (this.isLargeTuple(tupleSize)) {
            return this.getTupleCount() < 2 ? FrameOpSpaceStatus.EXPAND : FrameOpSpaceStatus.INSUFFICIENT_SPACE;
        }
        return super.hasSpaceInsert(tuple);
    }

    public FrameOpSpaceStatus hasSpaceUpdate(ITupleReference newTuple, int oldTupleIndex) {
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, oldTupleIndex);
        int oldTupleBytes = this.frameTuple.getTupleSize();
        int newTupleBytes = this.tupleWriter.bytesRequired(newTuple);
        FrameOpSpaceStatus status = this.hasSpaceUpdate(oldTupleBytes, newTupleBytes);
        if (status == FrameOpSpaceStatus.INSUFFICIENT_SPACE && (this.getLargeFlag() || this.getTupleCount() == 1) && this.isLargeTuple(newTupleBytes)) {
            return FrameOpSpaceStatus.EXPAND;
        }
        return status;
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey, IExtraPageBlockHelper extraPageBlockHelper, IBufferCache bufferCache) throws HyracksDataException {
        BTreeNSMLeafFrame targetFrame;
        int tupleSize = this.getBytesRequiredToWriteTuple(tuple);
        boolean tupleLarge = this.isLargeTuple(tupleSize);
        int tupleCount = this.getTupleCount();
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleCount - 1);
        if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) > 0) {
            targetFrame = (BTreeNSMLeafFrame)rightFrame;
        } else {
            int tuplesToLeft;
            int i;
            int totalSize = 0;
            int halfPageSize = (this.buf.capacity() - this.getPageHeaderSize()) / 2;
            for (i = 0; i < tupleCount; ++i) {
                this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
                if ((totalSize += this.tupleWriter.getCopySpaceRequired((ITupleReference)this.frameTuple) + this.slotManager.getSlotSize()) >= halfPageSize) break;
            }
            if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) >= 0) {
                tuplesToLeft = i + 1;
                targetFrame = (BTreeNSMLeafFrame)rightFrame;
            } else {
                tuplesToLeft = i;
                targetFrame = this;
            }
            int tuplesToRight = tupleCount - tuplesToLeft;
            ((BTreeNSMLeafFrame)rightFrame).setLargeFlag(this.getLargeFlag());
            int deltaPages = this.page.getFrameSizeMultiplier() - rightFrame.getPage().getFrameSizeMultiplier();
            if (deltaPages > 0) {
                ((BTreeNSMLeafFrame)rightFrame).growCapacity(extraPageBlockHelper, bufferCache, deltaPages);
            }
            ByteBuffer right = rightFrame.getBuffer();
            System.arraycopy(this.buf.array(), 0, right.array(), 0, this.buf.capacity());
            int src = rightFrame.getSlotManager().getSlotEndOff();
            int dest = rightFrame.getSlotManager().getSlotEndOff() + tuplesToLeft * rightFrame.getSlotManager().getSlotSize();
            int length = rightFrame.getSlotManager().getSlotSize() * tuplesToRight;
            System.arraycopy(right.array(), src, right.array(), dest, length);
            right.putInt(0, tuplesToRight);
            this.buf.putInt(0, tuplesToLeft);
            rightFrame.compact();
            this.compact();
        }
        if (tupleLarge) {
            targetFrame.ensureCapacity(bufferCache, tuple, extraPageBlockHelper);
        }
        int targetTupleIndex = targetFrame.findInsertTupleIndex(tuple);
        targetFrame.insert(tuple, targetTupleIndex);
        int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotEndOff());
        this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount());
        splitKey.initData(splitKeySize);
        this.tupleWriter.writeTupleFields((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount(), splitKey.getBuffer().array(), 0);
        splitKey.getTuple().resetByTupleOffset(splitKey.getBuffer().array(), 0);
    }

    @Override
    public void ensureCapacity(IBufferCache bufferCache, ITupleReference tuple, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.setLargeFlag(true);
        int gapBytes = this.getBytesRequiredToWriteTuple(tuple) - this.getFreeContiguousSpace();
        if (gapBytes > 0) {
            int deltaPages = (int)Math.ceil((double)gapBytes / (double)bufferCache.getPageSize());
            this.growCapacity(extraPageBlockHelper, bufferCache, deltaPages);
        }
    }

    private void growCapacity(IExtraPageBlockHelper extraPageBlockHelper, IBufferCache bufferCache, int deltaPages) throws HyracksDataException {
        int framePagesOld = this.page.getFrameSizeMultiplier();
        int newMultiplier = framePagesOld + deltaPages;
        int oldSlotEnd = this.slotManager.getSlotEndOff();
        int oldSlotStart = this.slotManager.getSlotStartOff() + this.slotManager.getSlotSize();
        bufferCache.resizePage(this.getPage(), newMultiplier, extraPageBlockHelper);
        this.buf = this.getPage().getBuffer();
        System.arraycopy(this.buf.array(), oldSlotEnd, this.buf.array(), this.slotManager.getSlotEndOff(), oldSlotStart - oldSlotEnd);
        this.buf.putInt(17, this.buf.getInt(17) + bufferCache.getPageSize() * deltaPages);
    }

    @Override
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference pageTuple, MultiComparator cmp, FindTupleMode ftm, FindTupleNoExactMatchPolicy ftp) throws HyracksDataException {
        return this.slotManager.findTupleIndex(searchKey, pageTuple, cmp, ftm, ftp);
    }

    public void setMultiComparator(MultiComparator cmp) {
        this.cmp = cmp;
    }

    @Override
    public void validate(BTreeOpContext.PageValidationInfo pvi) throws HyracksDataException {
        int tupleCount = this.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            if (!pvi.isLowRangeNull) assert (this.cmp.compare((ITupleReference)pvi.lowRangeTuple, (ITupleReference)this.frameTuple) < 0);
            if (!pvi.isHighRangeNull) assert (this.cmp.compare((ITupleReference)pvi.highRangeTuple, (ITupleReference)this.frameTuple) >= 0);
            if (i <= 0) continue;
            this.previousFt.resetByTupleIndex((ITreeIndexFrame)this, i - 1);
            assert (this.cmp.compare((ITupleReference)this.previousFt, (ITupleReference)this.frameTuple) < 0);
        }
    }

    public String printHeader() {
        StringBuilder strBuilder = new StringBuilder(super.printHeader());
        strBuilder.append("nextLeafOff:       22\n");
        return strBuilder.toString();
    }
}

