/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockUtil {
    private MetadataLockUtil() {
    }

    public static void createDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String itemTypeDataverseName, String itemTypeFullyQualifiedName, String metaItemTypeDataverseName, String metaItemTypeFullyQualifiedName, String nodeGroupName, String compactionPolicyName, String datasetFullyQualifiedName, boolean isDefaultCompactionPolicy) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        if (!dataverseName.equals(itemTypeDataverseName)) {
            lockMgr.acquireDataverseReadLock(locks, itemTypeDataverseName);
        }
        if (metaItemTypeDataverseName != null && !metaItemTypeDataverseName.equals(dataverseName) && !metaItemTypeDataverseName.equals(itemTypeDataverseName)) {
            lockMgr.acquireDataverseReadLock(locks, metaItemTypeDataverseName);
        }
        lockMgr.acquireDataTypeReadLock(locks, itemTypeFullyQualifiedName);
        if (metaItemTypeFullyQualifiedName != null && !metaItemTypeFullyQualifiedName.equals(itemTypeFullyQualifiedName)) {
            lockMgr.acquireDataTypeReadLock(locks, metaItemTypeFullyQualifiedName);
        }
        if (nodeGroupName != null) {
            lockMgr.acquireNodeGroupReadLock(locks, nodeGroupName);
        }
        if (!isDefaultCompactionPolicy) {
            lockMgr.acquireMergePolicyReadLock(locks, compactionPolicyName);
        }
        lockMgr.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public static void createIndexBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetCreateIndexLock(locks, datasetFullyQualifiedName);
    }

    public static void dropIndexBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public static void createTypeBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String itemTypeFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, itemTypeFullyQualifiedName);
    }

    public static void dropDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public static void dropTypeBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String dataTypeFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, dataTypeFullyQualifiedName);
    }

    public static void functionStatementBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String functionFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFunctionWriteLock(locks, functionFullyQualifiedName);
    }

    public static void modifyDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetModifyLock(locks, datasetFullyQualifiedName);
    }

    public static void insertDeleteUpsertBegin(IMetadataLockManager lockMgr, LockList locks, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, MetadataUtil.getDataverseFromFullyQualifiedName(datasetFullyQualifiedName));
        lockMgr.acquireDatasetModifyLock(locks, datasetFullyQualifiedName);
    }

    public static void dropFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String feedFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, feedFullyQualifiedName);
    }

    public static void dropFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireActiveEntityWriteLock(locks, policyName);
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
    }

    public static void startFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, feedName);
    }

    public static void stopFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, feedName);
    }

    public static void createFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String feedFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, feedFullyQualifiedName);
    }

    public static void connectFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, feedFullyQualifiedName);
        lockMgr.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
    }

    public static void createFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFeedPolicyWriteLock(locks, policyName);
    }

    public static void disconnectFeedBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, feedFullyQualifiedName);
        lockMgr.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
    }

    public static void compactBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
    }

    public static void refreshDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String dataverseName, String datasetFullyQualifiedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetExclusiveModificationLock(locks, datasetFullyQualifiedName);
    }
}

