/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class IndexTupleTranslator
extends AbstractTupleTranslator<Index> {
    private static final long serialVersionUID = 1L;
    public static final int INDEX_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int INDEX_DATASETNAME_TUPLE_FIELD_INDEX = 1;
    public static final int INDEX_INDEXNAME_TUPLE_FIELD_INDEX = 2;
    public static final int INDEX_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    public static final String GRAM_LENGTH_FIELD_NAME = "GramLength";
    public static final String INDEX_SEARCHKEY_TYPE_FIELD_NAME = "SearchKeyType";
    public static final String INDEX_ISENFORCED_FIELD_NAME = "IsEnforced";
    public static final String INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME = "SearchKeySourceIndicator";
    private transient OrderedListBuilder listBuilder = new OrderedListBuilder();
    private transient OrderedListBuilder primaryKeyListBuilder = new OrderedListBuilder();
    private transient AOrderedListType stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
    private transient AOrderedListType int8List = new AOrderedListType((IAType)BuiltinType.AINT8, null);
    private transient ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
    private transient ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
    private transient AMutableInt8 aInt8 = new AMutableInt8(0);
    private ISerializerDeserializer<AInt32> intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private ISerializerDeserializer<AInt8> int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
    private ISerializerDeserializer<ARecord> recordSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.INDEX_RECORDTYPE);
    private final MetadataNode metadataNode;
    private final TxnId txnId;

    protected IndexTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.INDEX_DATASET.getFieldCount());
        this.txnId = txnId;
        this.metadataNode = metadataNode;
    }

    @Override
    public Index getMetadataEntityFromTuple(ITupleReference frameTuple) throws AlgebricksException, HyracksDataException {
        byte[] serRecord = frameTuple.getFieldData(3);
        int recordStartOffset = frameTuple.getFieldStart(3);
        int recordLength = frameTuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord rec = (ARecord)this.recordSerde.deserialize((DataInput)in);
        String dvName = ((AString)rec.getValueByPos(0)).getStringValue();
        String dsName = ((AString)rec.getValueByPos(1)).getStringValue();
        String indexName = ((AString)rec.getValueByPos(2)).getStringValue();
        DatasetConfig.IndexType indexStructure = DatasetConfig.IndexType.valueOf((String)((AString)rec.getValueByPos(3)).getStringValue());
        IACursor fieldNameCursor = ((AOrderedList)rec.getValueByPos(4)).getCursor();
        ArrayList<List<String>> searchKey = new ArrayList<List<String>>();
        while (fieldNameCursor.next()) {
            AOrderedList fieldNameList = (AOrderedList)fieldNameCursor.get();
            IACursor nestedFieldNameCursor = fieldNameList.getCursor();
            ArrayList<String> nestedFieldName = new ArrayList<String>();
            while (nestedFieldNameCursor.next()) {
                nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
            }
            searchKey.add(nestedFieldName);
        }
        int indexKeyTypeFieldPos = rec.getType().getFieldIndex(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
        ACollectionCursor fieldTypeCursor = new ACollectionCursor();
        if (indexKeyTypeFieldPos > 0) {
            fieldTypeCursor = ((AOrderedList)rec.getValueByPos(indexKeyTypeFieldPos)).getCursor();
        }
        List<IAType> searchKeyType = new ArrayList<IAType>(searchKey.size());
        while (fieldTypeCursor.next()) {
            String typeName = ((AString)fieldTypeCursor.get()).getStringValue();
            IAType fieldType = BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dvName, typeName, false);
            searchKeyType.add(fieldType);
        }
        boolean isOverridingKeyTypes = !searchKeyType.isEmpty();
        int isEnforcedFieldPos = rec.getType().getFieldIndex(INDEX_ISENFORCED_FIELD_NAME);
        Boolean isEnforcingKeys = false;
        if (isEnforcedFieldPos > 0) {
            isEnforcingKeys = ((ABoolean)rec.getValueByPos(isEnforcedFieldPos)).getBoolean();
        }
        Boolean isPrimaryIndex = ((ABoolean)rec.getValueByPos(5)).getBoolean();
        int pendingOp = ((AInt32)rec.getValueByPos(7)).getIntegerValue();
        int gramLength = -1;
        int gramLenPos = rec.getType().getFieldIndex(GRAM_LENGTH_FIELD_NAME);
        if (gramLenPos >= 0) {
            gramLength = ((AInt32)rec.getValueByPos(gramLenPos)).getIntegerValue();
        }
        ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>();
        int keyFieldSourceIndicatorIndex = rec.getType().getFieldIndex(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
        if (keyFieldSourceIndicatorIndex >= 0) {
            IACursor cursor = ((AOrderedList)rec.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
            while (cursor.next()) {
                keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
            }
        } else {
            for (int index = 0; index < searchKey.size(); ++index) {
                keyFieldSourceIndicator.add(0);
            }
        }
        if (searchKeyType.isEmpty()) {
            try {
                Dataset dSet = this.metadataNode.getDataset(this.txnId, dvName, dsName);
                String datatypeName = dSet.getItemTypeName();
                String datatypeDataverseName = dSet.getItemTypeDataverseName();
                ARecordType recordDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, datatypeDataverseName, datatypeName).getDatatype();
                String metatypeName = dSet.getMetaItemTypeName();
                String metatypeDataverseName = dSet.getMetaItemTypeDataverseName();
                ARecordType metaDt = null;
                if (metatypeName != null && metatypeDataverseName != null) {
                    metaDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, metatypeDataverseName, metatypeName).getDatatype();
                }
                searchKeyType = KeyFieldTypeUtil.getKeyTypes(recordDt, metaDt, searchKey, keyFieldSourceIndicator);
            }
            catch (RemoteException re) {
                throw HyracksDataException.create((Throwable)re);
            }
        }
        return new Index(dvName, dsName, indexName, indexStructure, searchKey, keyFieldSourceIndicator, searchKeyType, gramLength, isOverridingKeyTypes, isEnforcingKeys, isPrimaryIndex, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Index instance) throws HyracksDataException {
        Iterator<Object> iterator;
        this.tupleBuilder.reset();
        this.aString.setValue(instance.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(instance.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(instance.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.INDEX_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(instance.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getIndexType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INDEX_RECORDTYPE.getFieldTypes()[4]));
        List<List<String>> searchKey = instance.getKeyFieldNames();
        for (List<String> field : searchKey) {
            this.listBuilder.reset((AbstractCollectionType)this.stringList);
            for (String subField : field) {
                this.itemValue.reset();
                this.aString.setValue(subField);
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.itemValue.reset();
            this.listBuilder.write(this.itemValue.getDataOutput(), true);
            this.primaryKeyListBuilder.addItem((IValueReference)this.itemValue);
        }
        this.fieldValue.reset();
        this.primaryKeyListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        if (instance.isPrimaryIndex()) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
        } else {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, this.fieldValue.getDataOutput());
        }
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.intSerde.serialize((Object)new AInt32(instance.getPendingOp()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        if (instance.getGramLength() > 0) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(GRAM_LENGTH_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.intSerde.serialize((Object)new AInt32(instance.getGramLength()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
        if (instance.isOverridingKeyFieldTypes()) {
            OrderedListBuilder typeListBuilder = new OrderedListBuilder();
            typeListBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ANY, null));
            this.nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            List<IAType> searchKeyType = instance.getKeyFieldTypes();
            for (IAType type : searchKeyType) {
                this.itemValue.reset();
                this.aString.setValue(type.getTypeName());
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                typeListBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            typeListBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
        if (instance.isEnforced()) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(INDEX_ISENFORCED_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
        List<Integer> keySourceIndicator = instance.getKeyFieldSourceIndicators();
        boolean needSerialization = false;
        if (keySourceIndicator != null) {
            iterator = keySourceIndicator.iterator();
            while (iterator.hasNext()) {
                int source = (Integer)iterator.next();
                if (source == 0) continue;
                needSerialization = true;
                break;
            }
        }
        if (needSerialization) {
            this.listBuilder.reset((AbstractCollectionType)this.int8List);
            this.nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            iterator = keySourceIndicator.iterator();
            while (iterator.hasNext()) {
                int source = (Integer)iterator.next();
                this.itemValue.reset();
                this.aInt8.setValue((byte)source);
                this.int8Serde.serialize((Object)this.aInt8, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            this.listBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

