/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public abstract class AbstractCollectionType
extends AbstractComplexType {
    private static final long serialVersionUID = 1L;
    protected IAType itemType;

    AbstractCollectionType(IAType itemType, String typeName) {
        super(typeName);
        this.itemType = itemType;
    }

    public boolean isTyped() {
        return this.itemType != null;
    }

    public IAType getItemType() {
        return this.itemType;
    }

    public void setItemType(IAType itemType) {
        this.itemType = itemType;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ASTERIX_TYPE;
    }

    @Override
    public void generateNestedDerivedTypeNames() {
        if (this.itemType.getTypeTag().isDerivedType() && this.itemType.getTypeName() == null) {
            AbstractComplexType nestedType = (AbstractComplexType)this.itemType;
            nestedType.setTypeName(this.getTypeName() + "_Item");
            nestedType.generateNestedDerivedTypeNames();
        }
    }

    @Override
    public boolean containsType(IAType type) {
        return this.isTyped() && this.itemType.getTypeName().equals(type.getTypeName());
    }
}

