/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.EnumSet;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class StringIntToStringTypeComputer
extends AbstractResultTypeComputer {
    public static final StringIntToStringTypeComputer INSTANCE = new StringIntToStringTypeComputer(0, 0, 1, 1, false);
    public static final StringIntToStringTypeComputer INSTANCE_NULLABLE = new StringIntToStringTypeComputer(0, 0, 1, 1, true);
    public static final StringIntToStringTypeComputer INSTANCE_TRIPLE_STRING = new StringIntToStringTypeComputer(0, 2, 3, 3, false);
    public static final StringIntToStringTypeComputer INSTANCE_STRING_REGEXP_REPLACE_WITH_FLAG = new StringIntToStringTypeComputer(0, 3, 3, 3, false);
    private final int stringArgIdxMin;
    private final int stringArgIdxMax;
    private final int intArgIdxMin;
    private final int intArgIdxMax;
    private final boolean nullable;

    public StringIntToStringTypeComputer(int stringArgIdxMin, int stringArgIdxMax, int intArgIdxMin, int intArgIdxMax, boolean nullable) {
        this.stringArgIdxMin = stringArgIdxMin;
        this.stringArgIdxMax = stringArgIdxMax;
        this.intArgIdxMin = intArgIdxMin;
        this.intArgIdxMax = intArgIdxMax;
        this.nullable = nullable;
    }

    @Override
    public void checkArgType(String funcName, int argIndex, IAType type, SourceLocation sourceLoc) throws AlgebricksException {
        ATypeTag tag = type.getTypeTag();
        boolean expectedStringType = false;
        if (this.stringArgIdxMin <= argIndex && argIndex <= this.stringArgIdxMax) {
            if (tag == ATypeTag.STRING) {
                return;
            }
            expectedStringType = true;
        }
        boolean expectedIntType = false;
        if (this.intArgIdxMin <= argIndex && argIndex <= this.intArgIdxMax) {
            switch (tag) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    return;
                }
            }
            expectedIntType = true;
        }
        throw new TypeMismatchException(sourceLoc, funcName, (Integer)argIndex, tag, this.getExpectedTypes(expectedStringType, expectedIntType));
    }

    @Override
    public IAType getResultType(ILogicalExpression expr, IAType ... types) throws AlgebricksException {
        IAType resultType = BuiltinType.ASTRING;
        if (this.nullable) {
            resultType = AUnionType.createNullableType(resultType);
        }
        return resultType;
    }

    private ATypeTag[] getExpectedTypes(boolean expectedStringType, boolean expectedIntType) {
        EnumSet<ATypeTag> expectedTypes = EnumSet.noneOf(ATypeTag.class);
        if (expectedStringType) {
            expectedTypes.add(ATypeTag.STRING);
        }
        if (expectedIntType) {
            expectedTypes.add(ATypeTag.TINYINT);
            expectedTypes.add(ATypeTag.SMALLINT);
            expectedTypes.add(ATypeTag.INTEGER);
            expectedTypes.add(ATypeTag.BIGINT);
        }
        return expectedTypes.toArray(new ATypeTag[0]);
    }
}

