/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.om.exceptions.InvalidExpressionException;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class RecordAddFieldsTypeComputer
implements IResultTypeComputer {
    public static final RecordAddFieldsTypeComputer INSTANCE = new RecordAddFieldsTypeComputer();
    private static final String FIELD_NAME_NAME = "field-name";
    private static final String FIELD_VALUE_VALUE = "field-value";

    private RecordAddFieldsTypeComputer() {
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        String funcName = funcExpr.getFunctionIdentifier().getName();
        IAType type0 = (IAType)env.getType((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue());
        ARecordType inputRecordType = TypeComputeUtils.extractRecordType(type0);
        if (inputRecordType == null) {
            throw new TypeMismatchException(funcExpr.getSourceLocation(), funcName, (Integer)0, type0.getTypeTag(), ATypeTag.OBJECT);
        }
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        IAType type1 = (IAType)env.getType(arg1);
        AOrderedListType inputOrderedListType = TypeComputeUtils.extractOrderedListType(type1);
        if (inputOrderedListType == null) {
            return inputRecordType;
        }
        boolean unknownable = TypeHelper.canBeUnknown(type0) || TypeHelper.canBeUnknown(type1);
        HashMap<String, IAType> additionalFields = new HashMap<String, IAType>();
        ArrayList<String> resultFieldNames = new ArrayList<String>();
        ArrayList<IAType> resultFieldTypes = new ArrayList<IAType>();
        resultFieldNames.addAll(Arrays.asList(inputRecordType.getFieldNames()));
        Collections.sort(resultFieldNames);
        for (String fieldName : resultFieldNames) {
            if (inputRecordType.getFieldType(fieldName).getTypeTag() == ATypeTag.OBJECT) {
                ARecordType nestedType = (ARecordType)inputRecordType.getFieldType(fieldName);
                resultFieldTypes.add(nestedType.deepCopy(nestedType));
                continue;
            }
            resultFieldTypes.add(inputRecordType.getFieldType(fieldName));
        }
        if (!this.containsVariable(arg1)) {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)arg1;
            List args = f.getArguments();
            String fieldName = null;
            IAType fieldType = null;
            for (Mutable arg : args) {
                AbstractFunctionCallExpression recConsExpr = (AbstractFunctionCallExpression)arg.getValue();
                ARecordType rtype = TypeComputeUtils.extractRecordType((IAType)env.getType((ILogicalExpression)recConsExpr));
                if (rtype == null) continue;
                String[] fn = rtype.getFieldNames();
                IAType[] ft = rtype.getFieldTypes();
                for (int j = 0; j < fn.length; ++j) {
                    if (fn[j].equals(FIELD_NAME_NAME)) {
                        ILogicalExpression fieldNameExpr = (ILogicalExpression)((Mutable)recConsExpr.getArguments().get(j)).getValue();
                        if (ConstantExpressionUtil.getStringConstant(fieldNameExpr) == null) {
                            throw new InvalidExpressionException(funcExpr.getSourceLocation(), funcName, 1, fieldNameExpr, LogicalExpressionTag.CONSTANT);
                        }
                        fieldName = ConstantExpressionUtil.getStringArgument(recConsExpr, j + 1);
                        continue;
                    }
                    if (!fn[j].equals(FIELD_VALUE_VALUE)) continue;
                    fieldType = ft[j];
                }
                if (fieldName == null) continue;
                additionalFields.put(fieldName, fieldType);
            }
            if (!additionalFields.isEmpty()) {
                for (Map.Entry entry : additionalFields.entrySet()) {
                    resultFieldNames.add((String)entry.getKey());
                    resultFieldTypes.add((IAType)entry.getValue());
                }
            }
        }
        String resultTypeName = "appended(" + inputRecordType.getTypeName() + ")";
        int n = resultFieldNames.size();
        IAType resultType = new ARecordType(resultTypeName, resultFieldNames.toArray(new String[n]), resultFieldTypes.toArray(new IAType[n]), true);
        if (unknownable) {
            resultType = AUnionType.createUnknownableType(resultType);
        }
        return resultType;
    }

    private boolean containsVariable(ILogicalExpression expression) {
        AbstractFunctionCallExpression f;
        List args;
        Iterator iterator;
        if (expression.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (iterator = (args = (f = (AbstractFunctionCallExpression)expression).getArguments()).iterator()).hasNext()) {
            Mutable arg = (Mutable)iterator.next();
            ILogicalExpression subExpression = (ILogicalExpression)arg.getValue();
            switch (subExpression.getExpressionTag()) {
                case VARIABLE: {
                    return true;
                }
                case CONSTANT: {
                    return false;
                }
            }
            return this.containsVariable(subExpression);
        }
        return true;
    }
}

