/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class NumericUnaryFunctionTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericUnaryFunctionTypeComputer INSTANCE = new NumericUnaryFunctionTypeComputer();

    private NumericUnaryFunctionTypeComputer() {
    }

    @Override
    protected void checkArgType(String funcName, int argIndex, IAType type, SourceLocation sourceLoc) throws AlgebricksException {
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case ANY: {
                break;
            }
            default: {
                throw new TypeMismatchException(sourceLoc, funcName, (Integer)argIndex, tag, ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE);
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        switch (tag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case ANY: {
                return strippedInputTypes[0];
            }
        }
        return null;
    }
}

