/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class IfNanOrInfTypeComputer
extends AbstractResultTypeComputer {
    public static final IfNanOrInfTypeComputer INSTANCE = new IfNanOrInfTypeComputer();

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        if (strippedInputTypes.length == 0) {
            return BuiltinType.ANULL;
        }
        boolean any = false;
        IAType currentType = null;
        for (IAType type : strippedInputTypes) {
            if (currentType != null && !type.equals(currentType)) {
                any = true;
                break;
            }
            currentType = type;
        }
        if (any || currentType == null) {
            return BuiltinType.ANY;
        }
        switch (currentType.getTypeTag()) {
            case ANY: 
            case MISSING: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                return currentType;
            }
            case DOUBLE: 
            case FLOAT: {
                return AUnionType.createNullableType(currentType, null);
            }
        }
        return BuiltinType.ANULL;
    }

    @Override
    protected boolean propagateNullAndMissing() {
        return false;
    }
}

