/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class AListTypeComputer
extends AbstractResultTypeComputer {
    public static final AListTypeComputer INSTANCE_REMOVE = new AListTypeComputer(2, -1, false, false, true);
    public static final AListTypeComputer INSTANCE_PUT = new AListTypeComputer(2, -1, false, true, true);
    public static final AListTypeComputer INSTANCE_PREPEND = new AListTypeComputer(2, -1, true, true, false);
    public static final AListTypeComputer INSTANCE_APPEND = new AListTypeComputer(2, -1, false, true, false);
    public static final AListTypeComputer INSTANCE_INSERT = new AListTypeComputer(3, -1, false, true, false);
    public static final AListTypeComputer INSTANCE_REPLACE = new AListTypeComputer(3, 4, false, true, false);
    private final int minNumArgs;
    private final int maxNumArgs;
    private final boolean listIsLast;
    private final boolean makeOpen;
    private final boolean nullInNullOut;

    private AListTypeComputer(int minNumArgs, int maxNumArgs, boolean listIsLast, boolean makeOpen, boolean nullInNullOut) {
        this.minNumArgs = minNumArgs;
        this.maxNumArgs = maxNumArgs;
        this.listIsLast = listIsLast;
        this.makeOpen = makeOpen;
        this.nullInNullOut = nullInNullOut;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType listType;
        if (strippedInputTypes.length < this.minNumArgs || this.maxNumArgs > 0 && strippedInputTypes.length > this.maxNumArgs) {
            String functionName = ((AbstractFunctionCallExpression)expr).getFunctionIdentifier().getName();
            throw new CompilationException(1087, expr.getSourceLocation(), new Serializable[]{functionName});
        }
        int listIndex = 0;
        if (this.listIsLast) {
            listIndex = strippedInputTypes.length - 1;
        }
        if ((listType = strippedInputTypes[listIndex]).getTypeTag().isListType()) {
            if (this.makeOpen) {
                listType = DefaultOpenFieldType.getDefaultOpenFieldType(listType.getTypeTag());
            }
            return AUnionType.createUnknownableType(listType);
        }
        return BuiltinType.ANY;
    }

    @Override
    protected boolean propagateNullAndMissing() {
        return this.nullInNullOut;
    }
}

