/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class RawBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static IBinaryComparatorFactory INSTANCE = new RawBinaryComparatorFactory();

    private RawBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return new IBinaryComparator(){

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                int commonLength = Math.min(l1, l2);
                for (int i = 0; i < commonLength; ++i) {
                    if (b1[s1 + i] == b2[s2 + i]) continue;
                    return b1[s1 + i] - b2[s2 + i];
                }
                int difference = l1 - l2;
                return difference == 0 ? 0 : (difference > 0 ? 1 : -1);
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return INSTANCE;
    }
}

