/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.aoya;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.aoya.AsterixYARNClient;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.event.schema.yarnCluster.Cluster;
import org.apache.asterix.event.schema.yarnCluster.Node;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class Utils {
    private static final String CONF_DIR_REL = AsterixYARNClient.CONF_DIR_REL;

    private Utils() {
    }

    public static String hostFromContainerID(String containerID) {
        return containerID.split("_")[4];
    }

    public static Node getMetadataNode(Cluster cluster) {
        Node metadataNode = null;
        if (cluster.getMetadataNode() != null) {
            for (Node node : cluster.getNode()) {
                if (!node.getId().equals(cluster.getMetadataNode())) continue;
                metadataNode = node;
                break;
            }
        } else {
            metadataNode = (Node)cluster.getNode().get(1);
        }
        return metadataNode;
    }

    public static void sendShutdownCall(String host, int port) throws IOException {
        String url = "http://" + host + ":" + port + "/admin/shutdown";
        PostMethod method = new PostMethod(url);
        try {
            Utils.executeHTTPCall((HttpMethod)method);
        }
        catch (NoHttpResponseException noHttpResponseException) {
            // empty catch block
        }
        try {
            Utils.executeHTTPCall((HttpMethod)method);
        }
        catch (ConnectException e) {
            return;
        }
        throw new IOException("Instance did not shut down cleanly.");
    }

    public static boolean probeLiveness(String host, int port) throws IOException {
        InputStream response;
        String url = "http://" + host + ":" + port + "/query";
        String test = "for $x in dataset Metadata.Dataset return $x;";
        GetMethod method = new GetMethod(url);
        method.setQueryString(new NameValuePair[]{new NameValuePair("query", "for $x in dataset Metadata.Dataset return $x;")});
        try {
            response = Utils.executeHTTPCall((HttpMethod)method);
        }
        catch (ConnectException e) {
            return false;
        }
        if (response == null) {
            return false;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(response));
        String result = br.readLine();
        if (result == null) {
            return false;
        }
        return method.getStatusCode() == 200;
    }

    private static InputStream executeHTTPCall(HttpMethod method) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        HttpMethodRetryHandler noop = new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                return false;
            }
        };
        client.getParams().setParameter("http.method.retry-handler", (Object)noop);
        client.executeMethod(method);
        return method.getResponseBodyAsStream();
    }

    public static String makeDots(int iter) {
        int pos = iter % 3;
        char[] dots = new char[]{' ', ' ', ' '};
        dots[pos] = 46;
        return new String(dots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean confirmAction(String warning) {
        System.out.println(warning);
        System.out.print("Are you sure you want to do this? (yes/no): ");
        Scanner in = new Scanner(System.in);
        while (true) {
            try {
                String input = in.nextLine();
                if ("yes".equals(input)) {
                    boolean bl = true;
                    return bl;
                }
                if ("no".equals(input)) {
                    boolean bl = false;
                    return bl;
                }
                System.out.println("Please type yes or no");
                continue;
            }
            finally {
                in.close();
                continue;
            }
            break;
        }
    }

    public static void listInstances(Configuration conf, String confDirRel) throws IOException {
        Path instanceFolder;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(instanceFolder = new Path(fs.getHomeDirectory(), confDirRel))) {
            System.out.println("No running or stopped AsterixDB instances exist in this cluster.");
            return;
        }
        FileStatus[] instances = fs.listStatus(instanceFolder);
        if (instances.length != 0) {
            System.out.println("Existing AsterixDB instances: ");
            for (int i = 0; i < instances.length; ++i) {
                FileStatus st = instances[i];
                String name = st.getPath().getName();
                ApplicationId lockFile = AsterixYARNClient.getLockFile(name, conf);
                if (lockFile != null) {
                    System.out.println("Instance " + name + " is running with Application ID: " + lockFile.toString());
                    continue;
                }
                System.out.println("Instance " + name + " is stopped");
            }
        } else {
            System.out.println("No running or stopped AsterixDB instances exist in this cluster");
        }
    }

    public static void listBackups(Configuration conf, String confDirRel, String instance) throws IOException {
        List<String> backups = Utils.getBackups(conf, confDirRel, instance);
        if (backups.size() != 0) {
            System.out.println("Backups for instance " + instance + ": ");
            for (String name : backups) {
                System.out.println("Backup: " + name);
            }
        } else {
            System.out.println("No backups found for instance " + instance + ".");
        }
    }

    public static List<String> getBackups(Configuration conf, String confDirRel, String instance) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path backupFolder = new Path(fs.getHomeDirectory(), confDirRel + "/" + instance + "/backups");
        FileStatus[] backups = fs.listStatus(backupFolder);
        ArrayList<String> backupNames = new ArrayList<String>();
        for (FileStatus f : backups) {
            backupNames.add(f.getPath().getName());
        }
        return backupNames;
    }

    public static void rmBackup(Configuration conf, String confDirRel, String instance, long timestamp) throws IOException {
        Path backupFolder;
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] backups = fs.listStatus(backupFolder = new Path(fs.getHomeDirectory(), confDirRel + "/" + instance + "/backups"));
        if (backups.length != 0) {
            System.out.println("Backups for instance " + instance + ": ");
        } else {
            System.out.println("No backups found for instance " + instance + ".");
        }
        for (FileStatus f : backups) {
            String name = f.getPath().getName();
            long file_ts = Long.parseLong(name);
            if (file_ts != timestamp) continue;
            System.out.println("Deleting backup " + timestamp);
            if (!fs.delete(f.getPath(), true)) {
                System.out.println("Backup could not be deleted");
                return;
            }
            return;
        }
        System.out.println("No backup found with specified timestamp");
    }

    public static Cluster parseYarnClusterConfig(String path) throws YarnException {
        try {
            File f = new File(path);
            JAXBContext configCtx = JAXBContext.newInstance((Class[])new Class[]{Cluster.class});
            Unmarshaller unmarshaller = configCtx.createUnmarshaller();
            Cluster cl = (Cluster)unmarshaller.unmarshal(f);
            return cl;
        }
        catch (JAXBException e) {
            throw new YarnException((Throwable)e);
        }
    }

    public static void writeYarnClusterConfig(String path, Cluster cl) throws YarnException {
        try {
            File f = new File(path);
            JAXBContext configCtx = JAXBContext.newInstance((Class[])new Class[]{Cluster.class});
            Marshaller marhsaller = configCtx.createMarshaller();
            marhsaller.marshal((Object)cl, f);
        }
        catch (JAXBException e) {
            throw new YarnException((Throwable)e);
        }
    }

    public static String getAsterixVersionFromClasspath() {
        String[] cp = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        String asterixJarPattern = "^(asterix).*(jar)$";
        for (String j : cp) {
            String[] pathComponents = j.split(Pattern.quote(File.separator));
            if (!pathComponents[pathComponents.length - 1].matches(asterixJarPattern)) continue;
            String[] byDash = pathComponents[pathComponents.length - 1].split("-");
            String version = byDash[2].split("\\.")[0];
            if (byDash.length == 4) {
                return version + '-' + byDash[3].split("\\.")[0];
            }
            return version;
        }
        return null;
    }

    public static boolean waitForLiveness(ApplicationId appId, boolean probe, boolean print, String message, YarnClient yarnClient, String instanceName, Configuration conf, int port) throws YarnException {
        ApplicationReport report;
        try {
            report = yarnClient.getApplicationReport(appId);
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        YarnApplicationState st = report.getYarnApplicationState();
        for (int i = 0; i < 120; ++i) {
            if (st != YarnApplicationState.RUNNING) {
                try {
                    report = yarnClient.getApplicationReport(appId);
                    st = report.getYarnApplicationState();
                    if (print) {
                        System.out.print(message + Utils.makeDots(i) + "\r");
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e1) {
                    throw new YarnException((Throwable)e1);
                }
                if (st == YarnApplicationState.FAILED || st == YarnApplicationState.FINISHED || st == YarnApplicationState.KILLED) {
                    return false;
                }
            }
            if (probe) {
                String host = Utils.getCCHostname(instanceName, conf);
                try {
                    for (int j = 0; j < 60; ++j) {
                        if (!Utils.probeLiveness(host, port)) {
                            try {
                                if (print) {
                                    System.out.print(message + Utils.makeDots(i) + "\r");
                                }
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e2) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        if (print) {
                            System.out.println("");
                        }
                        return true;
                    }
                    continue;
                }
                catch (IOException e1) {
                    throw new YarnException((Throwable)e1);
                }
            }
            if (print) {
                System.out.println("");
            }
            return true;
        }
        if (print) {
            System.out.println("");
        }
        return false;
    }

    public static boolean waitForLiveness(ApplicationId appId, String message, YarnClient yarnClient, String instanceName, Configuration conf, int port) throws YarnException, IOException {
        return Utils.waitForLiveness(appId, true, true, message, yarnClient, instanceName, conf, port);
    }

    public static boolean waitForApplication(ApplicationId appId, YarnClient yarnClient, String message, int port) throws YarnException, IOException {
        return Utils.waitForLiveness(appId, false, true, message, yarnClient, "", null, port);
    }

    public static boolean waitForApplication(ApplicationId appId, YarnClient yarnClient, int port) throws YarnException, IOException, JAXBException {
        return Utils.waitForLiveness(appId, false, false, "", yarnClient, "", null, port);
    }

    public static String getCCHostname(String instanceName, Configuration conf) throws YarnException {
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            String instanceFolder = instanceName + "/";
            String pathSuffix = CONF_DIR_REL + instanceFolder + "cluster-config.xml";
            Path dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
            File tmp = File.createTempFile("cluster-config", "xml");
            tmp.deleteOnExit();
            fs.copyToLocalFile(dstConf, new Path(tmp.getPath()));
            JAXBContext clusterConf = JAXBContext.newInstance((Class[])new Class[]{Cluster.class});
            Unmarshaller unm = clusterConf.createUnmarshaller();
            Cluster cl = (Cluster)unm.unmarshal(tmp);
            String ccIp = cl.getMasterNode().getClientIp();
            return ccIp;
        }
        catch (IOException | JAXBException e) {
            throw new YarnException(e);
        }
    }

    public static AsterixConfiguration loadAsterixConfig(String path) throws IOException {
        File f = new File(path);
        try {
            JAXBContext configCtx = JAXBContext.newInstance((Class[])new Class[]{AsterixConfiguration.class});
            Unmarshaller unmarshaller = configCtx.createUnmarshaller();
            AsterixConfiguration conf = (AsterixConfiguration)unmarshaller.unmarshal(f);
            return conf;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

