/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.aoya;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.asterix.aoya.Utils;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.common.configuration.Coredump;
import org.apache.asterix.common.configuration.Property;
import org.apache.asterix.common.configuration.Store;
import org.apache.asterix.common.configuration.TransactionLogDir;
import org.apache.asterix.event.schema.yarnCluster.Cluster;
import org.apache.asterix.event.schema.yarnCluster.Node;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AsterixYARNClient {
    public static final Map<String, Mode> STRING_TO_MODE = ImmutableMap.builder().put((Object)Mode.INSTALL.alias, (Object)Mode.INSTALL).put((Object)Mode.START.alias, (Object)Mode.START).put((Object)Mode.STOP.alias, (Object)Mode.STOP).put((Object)Mode.KILL.alias, (Object)Mode.KILL).put((Object)Mode.DESTROY.alias, (Object)Mode.DESTROY).put((Object)Mode.ALTER.alias, (Object)Mode.ALTER).put((Object)Mode.LIBINSTALL.alias, (Object)Mode.LIBINSTALL).put((Object)Mode.DESCRIBE.alias, (Object)Mode.DESCRIBE).put((Object)Mode.BACKUP.alias, (Object)Mode.BACKUP).put((Object)Mode.LSBACKUP.alias, (Object)Mode.LSBACKUP).put((Object)Mode.RMBACKUP.alias, (Object)Mode.RMBACKUP).put((Object)Mode.RESTORE.alias, (Object)Mode.RESTORE).build();
    private static final Log LOG = LogFactory.getLog(AsterixYARNClient.class);
    public static final String CONF_DIR_REL = ".asterix" + File.separator;
    private static final String instanceLock = "instance";
    public static final String CONFIG_DEFAULT_NAME = "cluster-config.xml";
    public static final String PARAMS_DEFAULT_NAME = "asterix-configuration.xml";
    private static String DEFAULT_PARAMETERS_PATH = "conf" + File.separator + "base-asterix-configuration.xml";
    private static String MERGED_PARAMETERS_PATH = "conf" + File.separator + "asterix-configuration.xml";
    private static final String JAVA_HOME = System.getProperty("java.home");
    public static final String NC_JAVA_OPTS_KEY = "nc.java.opts";
    public static final String CC_JAVA_OPTS_KEY = "cc.java.opts";
    public static final String CC_REST_PORT_KEY = "api.port";
    private Mode mode = Mode.NOOP;
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private int amMemory = 1000;
    private final String appMasterMainClass = "org.apache.asterix.aoya.AsterixApplicationMaster";
    private String instanceName = "";
    private String asterixZip = "";
    private String asterixConf = "";
    private String extLibs = "";
    private String instanceFolder = "";
    private String log4jPropFile = "";
    boolean debugFlag = false;
    private boolean refresh = false;
    private boolean force = false;
    private Options opts;
    private String libDataverse;
    private String snapName = "";
    private String baseConfig = ".";
    private String ccJavaOpts = "";
    private String ncJavaOpts = "";
    private int ccRestPort = 19002;

    public static void main(String[] args) {
        try {
            AsterixYARNClient client = new AsterixYARNClient();
            try {
                client.init(args);
                AsterixYARNClient.execute(client);
            }
            catch (ParseException | ApplicationNotFoundException e) {
                LOG.fatal((Object)e);
                client.printUsage();
                System.exit(-1);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Error running client", (Throwable)e);
            System.exit(1);
        }
        LOG.info((Object)"Command executed successfully.");
        System.exit(0);
    }

    public static void execute(AsterixYARNClient client) throws IOException, YarnException {
        System.out.println("JAVA HOME: " + JAVA_HOME);
        switch (client.mode) {
            case START: {
                AsterixYARNClient.startAction(client);
                break;
            }
            case STOP: {
                try {
                    client.stopInstance();
                }
                catch (ApplicationNotFoundException e) {
                    LOG.info((Object)e);
                    System.out.println("Asterix instance by that name already exited or was never started");
                    client.deleteLockFile();
                }
                break;
            }
            case KILL: {
                if (client.isRunning() && Utils.confirmAction("Are you sure you want to kill this instance? In-progress tasks will be aborted")) {
                    try {
                        AsterixYARNClient.killApplication(client.getLockFile(), client.yarnClient);
                    }
                    catch (ApplicationNotFoundException e) {
                        LOG.info((Object)e);
                        System.out.println("Asterix instance by that name already exited or was never started");
                        client.deleteLockFile();
                    }
                    break;
                }
                if (client.isRunning()) break;
                System.out.println("Asterix instance by that name already exited or was never started");
                client.deleteLockFile();
                break;
            }
            case DESCRIBE: {
                Utils.listInstances(client.conf, CONF_DIR_REL);
                break;
            }
            case INSTALL: {
                AsterixYARNClient.installAction(client);
                break;
            }
            case LIBINSTALL: {
                client.installExtLibs();
                break;
            }
            case ALTER: {
                client.writeAsterixConfig(Utils.parseYarnClusterConfig(client.asterixConf));
                client.installAsterixConfig(true);
                System.out.println("Configuration successfully modified");
                break;
            }
            case DESTROY: {
                try {
                    if (!client.force && !Utils.confirmAction("Are you really sure you want to obliterate this instance? This action cannot be undone!")) break;
                    YarnClientApplication app = client.makeApplicationContext();
                    List<DFSResourceCoordinate> res = client.deployConfig();
                    res.addAll(client.distributeBinaries());
                    client.removeInstance(app, res);
                    break;
                }
                catch (IOException | YarnException e) {
                    LOG.error((Object)"Asterix failed to deploy on to cluster");
                    throw e;
                }
            }
            case BACKUP: {
                if (!client.force && !Utils.confirmAction("Performing a backup will stop a running instance.")) break;
                YarnClientApplication app = client.makeApplicationContext();
                List<DFSResourceCoordinate> res = client.deployConfig();
                res.addAll(client.distributeBinaries());
                client.backupInstance(app, res);
                break;
            }
            case LSBACKUP: {
                Utils.listBackups(client.conf, CONF_DIR_REL, client.instanceName);
                break;
            }
            case RMBACKUP: {
                Utils.rmBackup(client.conf, CONF_DIR_REL, client.instanceName, Long.parseLong(client.snapName));
                break;
            }
            case RESTORE: {
                if (!client.force && !Utils.confirmAction("Performing a restore will stop a running instance.")) break;
                YarnClientApplication app = client.makeApplicationContext();
                List<DFSResourceCoordinate> res = client.deployConfig();
                res.addAll(client.distributeBinaries());
                client.restoreInstance(app, res);
                break;
            }
            default: {
                LOG.fatal((Object)"Unknown mode. Known client modes are: start, stop, install, describe, kill, destroy, describe, backup, restore, lsbackup, rmbackup");
                client.printUsage();
                System.exit(-1);
            }
        }
    }

    private static void startAction(AsterixYARNClient client) throws YarnException {
        try {
            YarnClientApplication app = client.makeApplicationContext();
            List<DFSResourceCoordinate> res = client.deployConfig();
            res.addAll(client.distributeBinaries());
            ApplicationId appId = client.deployAM(app, res, client.mode);
            LOG.info((Object)("Asterix started up with Application ID: " + appId.toString()));
            if (!Utils.waitForLiveness(appId, "Waiting for AsterixDB instance to resume ", client.yarnClient, client.instanceName, client.conf, client.ccRestPort)) {
                LOG.fatal((Object)"AsterixDB appears to have failed to install and start");
                throw new YarnException("AsterixDB appears to have failed to install and start");
            }
            System.out.println("Asterix successfully deployed and is now running.");
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    private static void installAction(AsterixYARNClient client) throws YarnException {
        try {
            YarnClientApplication app = client.makeApplicationContext();
            client.installConfig();
            client.writeAsterixConfig(Utils.parseYarnClusterConfig(client.asterixConf));
            client.installAsterixConfig(false);
            List<DFSResourceCoordinate> res = client.deployConfig();
            res.addAll(client.distributeBinaries());
            ApplicationId appId = client.deployAM(app, res, client.mode);
            LOG.info((Object)("Asterix started up with Application ID: " + appId.toString()));
            if (!Utils.waitForLiveness(appId, "Waiting for new AsterixDB Instance to start ", client.yarnClient, client.instanceName, client.conf, client.ccRestPort)) {
                LOG.fatal((Object)"AsterixDB appears to have failed to install and start");
                throw new YarnException("AsterixDB appears to have failed to install and start");
            }
            System.out.println("Asterix successfully deployed and is now running.");
        }
        catch (IOException e) {
            LOG.fatal((Object)"Asterix failed to deploy on to cluster");
            throw new YarnException((Throwable)e);
        }
    }

    public AsterixYARNClient(Configuration conf) throws Exception {
        this.conf = conf;
        this.yarnClient = YarnClient.createYarnClient();
        if (conf.get("fs.hdfs.impl", null) == conf.get("fs.file.impl", null)) {
            conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
            conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        }
        this.yarnClient.init(conf);
        this.opts = AsterixYARNClient.parseConf(conf);
    }

    private static Options parseConf(Configuration conf) {
        Options opts = new Options();
        opts.addOption(new Option("appname", true, "Application Name. Default value - Asterix"));
        opts.addOption(new Option("priority", true, "Application Priority. Default 0"));
        opts.addOption(new Option("queue", true, "RM Queue in which this application is to be submitted"));
        opts.addOption(new Option("master_memory", true, "Amount of memory in MB to be requested to run the application master"));
        opts.addOption(new Option("log_properties", true, "log4j.properties file"));
        opts.addOption(new Option("n", "name", true, "Asterix instance name (required)"));
        opts.addOption(new Option("zip", "asterixZip", true, "zip file with AsterixDB inside- if in non-default location"));
        opts.addOption(new Option("bc", "baseConfig", true, "base Asterix parameters configuration file if not in default position"));
        opts.addOption(new Option("c", "asterixConf", true, "Asterix cluster config (required on install)"));
        opts.addOption(new Option("l", "externalLibs", true, "Libraries to deploy along with Asterix instance"));
        opts.addOption(new Option("ld", "libDataverse", true, "Dataverse to deploy external libraries to"));
        opts.addOption(new Option("r", "refresh", false, "If starting an existing instance, this will replace them with the local copy on startup"));
        opts.addOption(new Option("appId", true, "ApplicationID to monitor if running client in status monitor mode"));
        opts.addOption(new Option("masterLibsDir", true, "Directory that contains the JARs needed to run the AM"));
        opts.addOption(new Option("s", "snapshot", true, "Backup timestamp for arguments requiring a specific backup (rm, restore)"));
        opts.addOption(new Option("v", "debug", false, "Dump out debug information"));
        opts.addOption(new Option("help", false, "Print usage"));
        opts.addOption(new Option("f", "force", false, "Execute this command as fully as possible, disregarding any caution"));
        return opts;
    }

    public AsterixYARNClient() throws Exception {
        this((Configuration)new YarnConfiguration());
    }

    private void printUsage() {
        new HelpFormatter().printHelp("Asterix YARN client. Usage: asterix [options] [mode]", this.opts);
    }

    public void init(String[] args) throws ParseException {
        CommandLine cliParser = new GnuParser().parse(this.opts, args);
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return;
        }
        this.debugFlag = cliParser.hasOption("debug");
        this.force = cliParser.hasOption("force");
        this.baseConfig = cliParser.getOptionValue("baseConfig");
        this.extLibs = cliParser.getOptionValue("externalLibs");
        this.libDataverse = cliParser.getOptionValue("libDataverse");
        this.appName = cliParser.getOptionValue("appname", "AsterixDB");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        this.amMemory = Integer.parseInt(cliParser.getOptionValue("master_memory", "10"));
        this.instanceName = cliParser.getOptionValue("name");
        this.instanceFolder = this.instanceName + '/';
        this.appName = this.appName + ": " + this.instanceName;
        this.asterixConf = cliParser.getOptionValue("asterixConf");
        this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
        this.checkConfSanity(args, cliParser);
        this.initMode(args, cliParser);
        this.checkModeSanity(args, cliParser);
        this.refresh = cliParser.hasOption("refresh");
        this.snapName = cliParser.getOptionValue("snapshot");
        this.asterixZip = !cliParser.hasOption("asterixZip") && (this.mode == Mode.INSTALL || this.mode == Mode.ALTER || this.mode == Mode.DESTROY || this.mode == Mode.BACKUP) ? cliParser.getOptionValue("asterixZip", this.getAsterixDistributableLocation().getAbsolutePath()) : cliParser.getOptionValue("asterixZip");
    }

    private void checkConfSanity(String[] args, CommandLine cliParser) throws ParseException {
        String message = null;
        if (args.length == 0) {
            message = "No args specified for client to initialize";
        } else if (this.amMemory < 0) {
            message = "Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory;
        } else {
            return;
        }
        throw new ParseException(message);
    }

    private void initMode(String[] args, CommandLine cliParser) throws ParseException {
        List clientVerb = cliParser.getArgList();
        String message = null;
        if (clientVerb == null || clientVerb.size() < 1) {
            message = "You must specify an action.";
        } else if (clientVerb.size() > 1) {
            message = "Trailing arguments, or too many arguments. Only one action may be performed at a time.";
        }
        if (message != null) {
            throw new ParseException(message);
        }
        this.mode = Mode.fromAlias((String)clientVerb.get(0));
        if (this.mode == null) {
            this.mode = Mode.NOOP;
        }
    }

    private void checkModeSanity(String[] args, CommandLine cliParser) throws ParseException {
        String message = null;
        if (!cliParser.hasOption("name") && this.mode != Mode.DESCRIBE) {
            message = "You must give a name for the instance to be acted upon";
        } else if (this.mode == Mode.INSTALL && !cliParser.hasOption("asterixConf")) {
            message = "No Configuration XML given. Please specify a config for cluster installation";
        } else if (this.mode != Mode.START && cliParser.hasOption("refresh")) {
            message = "Cannot specify refresh in any mode besides start, mode is: " + (Object)((Object)this.mode);
        } else if (cliParser.hasOption("snapshot") && this.mode != Mode.RESTORE && this.mode != Mode.RMBACKUP) {
            message = "Cannot specify a snapshot to restore in any mode besides restore or rmbackup, mode is: " + (Object)((Object)this.mode);
        } else if (!(this.mode != Mode.ALTER && this.mode != Mode.INSTALL || this.baseConfig != null || new File(DEFAULT_PARAMETERS_PATH).exists())) {
            message = "Default asterix parameters file is not in the default location, and no custom location is specified";
        } else {
            return;
        }
        throw new ParseException(message);
    }

    private File getAsterixDistributableLocation() {
        File tarDir = new File("asterix");
        if (!tarDir.exists()) {
            throw new IllegalArgumentException("Default directory structure not in use- please specify an asterix zip and base config file to distribute");
        }
        WildcardFileFilter tarFilter = new WildcardFileFilter("asterix-server*.zip");
        File[] tarFiles = tarDir.listFiles((FileFilter)tarFilter);
        if (tarFiles.length != 1) {
            throw new IllegalArgumentException("There is more than one canonically named asterix distributable in the default directory. Please leave only one there.");
        }
        return tarFiles[0];
    }

    public YarnClientApplication makeApplicationContext() throws IOException, YarnException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path lock = new Path(fs.getHomeDirectory(), CONF_DIR_REL + this.instanceFolder + instanceLock);
        LOG.info((Object)"Running Deployment");
        this.yarnClient.start();
        if (fs.exists(lock)) {
            ApplicationId lockAppId = this.getLockFile();
            try {
                ApplicationReport previousAppReport = this.yarnClient.getApplicationReport(lockAppId);
                YarnApplicationState prevStatus = previousAppReport.getYarnApplicationState();
                if (prevStatus != YarnApplicationState.FAILED && prevStatus != YarnApplicationState.KILLED && prevStatus != YarnApplicationState.FINISHED && this.mode != Mode.DESTROY && this.mode != Mode.BACKUP && this.mode != Mode.RESTORE) {
                    throw new IllegalStateException("Instance is already running in: " + lockAppId);
                }
                if (this.mode != Mode.DESTROY && this.mode != Mode.BACKUP && this.mode != Mode.RESTORE) {
                    LOG.warn((Object)("Stale lockfile detected. Instance attempt " + lockAppId + " may have exited abnormally"));
                    this.deleteLockFile();
                }
            }
            catch (YarnException e) {
                LOG.warn((Object)"Stale lockfile detected, but the RM has no record of this application's last run. This is normal if the cluster was restarted.");
                this.deleteLockFile();
            }
        }
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        int maxMem = appResponse.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        if (this.amMemory > maxMem) {
            LOG.info((Object)("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem));
            this.amMemory = maxMem;
        }
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        appContext.setApplicationName(this.appName);
        return app;
    }

    private List<DFSResourceCoordinate> deployConfig() throws YarnException, IOException {
        FileStatus destStatus;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        ArrayList<DFSResourceCoordinate> resources = new ArrayList<DFSResourceCoordinate>(2);
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + CONFIG_DEFAULT_NAME;
        Path dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
        try {
            destStatus = fs.getFileStatus(dstConf);
        }
        catch (IOException e) {
            throw new YarnException("Asterix instance by that name does not appear to exist in DFS");
        }
        LocalResource asterixConfLoc = (LocalResource)Records.newRecord(LocalResource.class);
        asterixConfLoc.setType(LocalResourceType.FILE);
        asterixConfLoc.setVisibility(LocalResourceVisibility.PRIVATE);
        asterixConfLoc.setResource(ConverterUtils.getYarnUrlFromPath((Path)dstConf));
        asterixConfLoc.setTimestamp(destStatus.getModificationTime());
        DFSResourceCoordinate conf = new DFSResourceCoordinate();
        conf.envs.put(dstConf.toUri().toString(), "CONFLOCATION");
        conf.envs.put(Long.toString(asterixConfLoc.getSize()), "CONFLEN");
        conf.envs.put(Long.toString(asterixConfLoc.getTimestamp()), "CONFTIMESTAMP");
        conf.name = CONFIG_DEFAULT_NAME;
        conf.res = asterixConfLoc;
        resources.add(conf);
        return resources;
    }

    private void installConfig() throws YarnException, IOException {
        Path dstConf;
        FileSystem fs;
        block4: {
            fs = FileSystem.get((Configuration)this.conf);
            String pathSuffix = CONF_DIR_REL + this.instanceFolder + CONFIG_DEFAULT_NAME;
            dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
            try {
                fs.getFileStatus(dstConf);
                if (this.mode == Mode.INSTALL) {
                    throw new IllegalStateException("Instance with this name already exists.");
                }
            }
            catch (FileNotFoundException e) {
                if (this.mode != Mode.START) break block4;
                throw new IllegalStateException("Instance does not exist for this user", e);
            }
        }
        if (this.mode == Mode.INSTALL) {
            Path src = new Path(this.asterixConf);
            fs.copyFromLocalFile(false, true, src, dstConf);
        }
    }

    private void installExtLibs() throws IllegalStateException, IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (!this.instanceExists()) {
            throw new IllegalStateException("No instance by name " + this.instanceName + " found.");
        }
        if (this.isRunning()) {
            throw new IllegalStateException("Instance " + this.instanceName + " is running. Please stop it before installing any libraries.");
        }
        String libPathSuffix = CONF_DIR_REL + this.instanceFolder + "library" + "/" + this.libDataverse + "/";
        Path src = new Path(this.extLibs);
        String fullLibPath = libPathSuffix + src.getName();
        Path libFilePath = new Path(fs.getHomeDirectory(), fullLibPath);
        LOG.info((Object)"Copying Asterix external library to DFS");
        fs.copyFromLocalFile(false, true, src, libFilePath);
    }

    private List<DFSResourceCoordinate> installAmLibs() throws IllegalStateException, IOException {
        ArrayList<DFSResourceCoordinate> resources = new ArrayList<DFSResourceCoordinate>(2);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String fullLibPath = CONF_DIR_REL + this.instanceFolder + "am_jars" + "/";
        String[] cp = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        String asterixJarPattern = "^(asterix).*(jar)$";
        String commonsJarPattern = "^(commons).*(jar)$";
        String surefireJarPattern = "^(surefire).*(jar)$";
        String jUnitTestPattern = "^(asterix-yarn" + File.separator + "target)$";
        LOG.info((Object)File.separator);
        for (String j : cp) {
            String[] pathComponents = j.split(Pattern.quote(File.separator));
            LOG.info((Object)j);
            LOG.info((Object)pathComponents[pathComponents.length - 1]);
            if (!pathComponents[pathComponents.length - 1].matches(asterixJarPattern) && !pathComponents[pathComponents.length - 1].matches(commonsJarPattern) && !pathComponents[pathComponents.length - 1].matches(surefireJarPattern) && !pathComponents[pathComponents.length - 1].matches(jUnitTestPattern)) continue;
            LOG.info((Object)("Loading JAR/classpath: " + j));
            File f = new File(j);
            Path dst = new Path(fs.getHomeDirectory(), fullLibPath + f.getName());
            if (!fs.exists(dst) || this.refresh) {
                fs.copyFromLocalFile(false, true, new Path(f.getAbsolutePath()), dst);
            }
            FileStatus dstSt = fs.getFileStatus(dst);
            LocalResource amLib = (LocalResource)Records.newRecord(LocalResource.class);
            amLib.setType(LocalResourceType.FILE);
            amLib.setVisibility(LocalResourceVisibility.PRIVATE);
            amLib.setResource(ConverterUtils.getYarnUrlFromPath((Path)dst));
            amLib.setTimestamp(dstSt.getModificationTime());
            amLib.setSize(dstSt.getLen());
            DFSResourceCoordinate amLibCoord = new DFSResourceCoordinate();
            amLibCoord.res = amLib;
            amLibCoord.name = f.getName();
            if (f.getName().contains("asterix-yarn") || f.getName().contains("surefire")) {
                amLibCoord.envs.put(dst.toUri().toString(), "APPLICATIONMASTERJARLOCATION");
                amLibCoord.envs.put(Long.toString(dstSt.getLen()), "APPLICATIONMASTERJARLEN");
                amLibCoord.envs.put(Long.toString(dstSt.getModificationTime()), "APPLICATIONMASTERJARTIMESTAMP");
            }
            resources.add(amLibCoord);
        }
        if (resources.size() == 0) {
            throw new IOException("Required JARs are missing. Please check your directory structure");
        }
        return resources;
    }

    private void installAsterixConfig(boolean overwrite) throws IllegalStateException, IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        File srcfile = new File(MERGED_PARAMETERS_PATH);
        Path src = new Path(srcfile.getCanonicalPath());
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + File.separator + PARAMS_DEFAULT_NAME;
        Path dst = new Path(fs.getHomeDirectory(), pathSuffix);
        if (fs.exists(dst) && !overwrite) {
            throw new IllegalStateException("Instance exists. Please delete an existing instance before trying to overwrite");
        }
        fs.copyFromLocalFile(false, true, src, dst);
    }

    public List<DFSResourceCoordinate> distributeBinaries() throws IOException, YarnException {
        ArrayList<DFSResourceCoordinate> resources = new ArrayList<DFSResourceCoordinate>(2);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + "asterix-server.zip";
        Path dst = new Path(fs.getHomeDirectory(), pathSuffix);
        if (this.refresh && fs.exists(dst)) {
            fs.delete(dst, false);
        }
        if (!fs.exists(dst)) {
            Path src = new Path(this.asterixZip);
            LOG.info((Object)"Copying Asterix distributable to DFS");
            fs.copyFromLocalFile(false, true, src, dst);
        }
        FileStatus destStatus = fs.getFileStatus(dst);
        LocalResource asterixTarLoc = (LocalResource)Records.newRecord(LocalResource.class);
        asterixTarLoc.setType(LocalResourceType.ARCHIVE);
        asterixTarLoc.setVisibility(LocalResourceVisibility.PRIVATE);
        asterixTarLoc.setResource(ConverterUtils.getYarnUrlFromPath((Path)dst));
        asterixTarLoc.setTimestamp(destStatus.getModificationTime());
        DFSResourceCoordinate tar = new DFSResourceCoordinate();
        tar.envs.put(dst.toUri().toString(), "TARLOCATION");
        tar.envs.put(Long.toString(asterixTarLoc.getSize()), "TARLEN");
        tar.envs.put(Long.toString(asterixTarLoc.getTimestamp()), "TARTIMESTAMP");
        tar.res = asterixTarLoc;
        tar.name = "asterix-server.zip";
        resources.add(tar);
        if (!this.log4jPropFile.isEmpty()) {
            Path log4jSrc = new Path(this.log4jPropFile);
            Path log4jDst = new Path(fs.getHomeDirectory(), "log4j.props");
            fs.copyFromLocalFile(false, true, log4jSrc, log4jDst);
            FileStatus log4jFileStatus = fs.getFileStatus(log4jDst);
            LocalResource log4jRsrc = (LocalResource)Records.newRecord(LocalResource.class);
            log4jRsrc.setType(LocalResourceType.FILE);
            log4jRsrc.setVisibility(LocalResourceVisibility.PRIVATE);
            log4jRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)log4jDst.toUri()));
            log4jRsrc.setTimestamp(log4jFileStatus.getModificationTime());
            log4jRsrc.setSize(log4jFileStatus.getLen());
            DFSResourceCoordinate l4j = new DFSResourceCoordinate();
            tar.res = log4jRsrc;
            tar.name = "log4j.properties";
            resources.add(l4j);
        }
        resources.addAll(this.installAmLibs());
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationId deployAM(YarnClientApplication app, List<DFSResourceCoordinate> resources, Mode mode) throws IOException, YarnException {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        for (DFSResourceCoordinate dFSResourceCoordinate : resources) {
            localResources.put(dFSResourceCoordinate.name, dFSResourceCoordinate.res);
        }
        amContainer.setLocalResources(localResources);
        LOG.info((Object)"Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        for (DFSResourceCoordinate dFSResourceCoordinate : resources) {
            if (dFSResourceCoordinate.envs == null) continue;
            for (Map.Entry<String, String> e : dFSResourceCoordinate.envs.entrySet()) {
                env.put(e.getValue(), e.getKey());
            }
        }
        env.put("RMADDRESS", this.conf.get("yarn.resourcemanager.address"));
        env.put("RMSCHEDULERADDRESS", this.conf.get("yarn.resourcemanager.scheduler.address"));
        env.put("INSTANCESTORE", CONF_DIR_REL + this.instanceFolder);
        env.put("DFSBASE", FileSystem.get((Configuration)this.conf).getHomeDirectory().toUri().toString());
        env.put("CCJAVAOPTS", this.ccJavaOpts);
        env.put("NCJAVAOPTS", this.ncJavaOpts);
        StringBuilder stringBuilder = new StringBuilder("").append("./*");
        for (String string : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            stringBuilder.append(File.pathSeparatorChar);
            stringBuilder.append(string.trim());
        }
        stringBuilder.append(File.pathSeparatorChar).append("." + File.separator + "log4j.properties");
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            LOG.info((Object)"In YARN MiniCluster");
            stringBuilder.append(System.getProperty("path.separator"));
            stringBuilder.append(System.getProperty("java.class.path"));
            env.put("HADOOP_CONF_DIR", System.getProperty("user.dir") + File.separator + "target" + File.separator);
        }
        LOG.info((Object)("AM Classpath:" + stringBuilder.toString()));
        env.put("CLASSPATH", stringBuilder.toString());
        amContainer.setEnvironment(env);
        Vector<String> vector = new Vector<String>(30);
        LOG.info((Object)"Setting up app master command");
        vector.add(JAVA_HOME + File.separator + "bin" + File.separator + "java");
        vector.add("org.apache.asterix.aoya.AsterixApplicationMaster");
        if (this.debugFlag) {
            vector.add("-debug");
        }
        if (mode == Mode.DESTROY) {
            vector.add("-obliterate");
        } else if (mode == Mode.BACKUP) {
            vector.add("-backup");
        } else if (mode == Mode.RESTORE) {
            vector.add("-restore " + this.snapName);
        } else if (mode == Mode.INSTALL) {
            vector.add("-initial ");
        }
        if (this.refresh) {
            vector.add("-refresh");
        }
        vector.add("1><LOG_DIR>" + File.separator + "AppMaster.stdout");
        vector.add("2><LOG_DIR>" + File.separator + "AppMaster.stderr");
        StringBuilder command = new StringBuilder();
        for (CharSequence charSequence : vector) {
            command.append(charSequence).append(" ");
        }
        LOG.info((Object)("Completed setting up app master command " + command.toString()));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command.toString());
        amContainer.setCommands(commands);
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(this.amMemory);
        appContext.setResource(resource);
        appContext.setAMContainerSpec(amContainer);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.amPriority);
        appContext.setPriority(pri);
        appContext.setQueue(this.amQueue);
        LOG.info((Object)"Submitting application to ASM");
        this.yarnClient.submitApplication(appContext);
        if (mode == Mode.INSTALL || mode == Mode.START) {
            Path lock;
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            if (fs.exists(lock = new Path(fs.getHomeDirectory(), CONF_DIR_REL + this.instanceFolder + instanceLock))) {
                throw new IllegalStateException("Somehow, this instance has been launched twice. ");
            }
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(lock, true)));){
                out.write(app.getApplicationSubmissionContext().getApplicationId().toString());
                out.close();
            }
        }
        return app.getApplicationSubmissionContext().getApplicationId();
    }

    public static void killApplication(ApplicationId appId, YarnClient yarnClient) throws YarnException, IOException {
        ApplicationReport rep;
        YarnApplicationState st;
        if (appId == null) {
            throw new YarnException("No Application given to kill");
        }
        if (yarnClient.isInState(Service.STATE.INITED)) {
            yarnClient.start();
        }
        if ((st = (rep = yarnClient.getApplicationReport(appId)).getYarnApplicationState()) == YarnApplicationState.FINISHED || st == YarnApplicationState.KILLED || st == YarnApplicationState.FAILED) {
            LOG.info((Object)("Application " + appId + " already exited."));
            return;
        }
        LOG.info((Object)("Killing applicaiton with ID: " + appId));
        yarnClient.killApplication(appId);
    }

    private void stopInstanceIfRunning() throws IOException, YarnException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + CONFIG_DEFAULT_NAME;
        Path dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
        if (this.isRunning()) {
            try {
                this.stopInstance();
            }
            catch (IOException e) {
                throw new YarnException((Throwable)e);
            }
        } else if (!fs.exists(dstConf)) {
            throw new YarnException("No instance configured with that name exists");
        }
    }

    private void removeInstance(YarnClientApplication app, List<DFSResourceCoordinate> resources) throws IOException, YarnException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.stopInstanceIfRunning();
        ApplicationId deleter = this.deployAM(app, resources, Mode.DESTROY);
        boolean delete_start = Utils.waitForApplication(deleter, this.yarnClient, "Waiting for deletion to start", this.ccRestPort);
        if (!delete_start) {
            if (this.force) {
                fs.delete(new Path(CONF_DIR_REL + this.instanceFolder), true);
                LOG.error((Object)"Forcing deletion of HDFS resources");
            }
            LOG.fatal((Object)" of on-disk persistient resources on individual nodes failed.");
            throw new YarnException();
        }
        boolean deleted = this.waitForCompletion(deleter, "Deletion in progress");
        if (!deleted && !this.force) {
            LOG.fatal((Object)"Cleanup of on-disk persistent resources failed.");
            return;
        }
        fs.delete(new Path(CONF_DIR_REL + this.instanceFolder), true);
        System.out.println("Deletion of instance succeeded.");
    }

    private void backupInstance(YarnClientApplication app, List<DFSResourceCoordinate> resources) throws IOException, YarnException {
        this.stopInstanceIfRunning();
        ApplicationId backerUpper = this.deployAM(app, resources, Mode.BACKUP);
        boolean backupStart = Utils.waitForApplication(backerUpper, this.yarnClient, "Waiting for backup " + backerUpper.toString() + "to start", this.ccRestPort);
        if (!backupStart) {
            LOG.fatal((Object)"Backup failed to start");
            throw new YarnException();
        }
        boolean complete = this.waitForCompletion(backerUpper, "Backup in progress");
        if (!complete) {
            LOG.fatal((Object)"Backup failed- timeout waiting for completion");
            return;
        }
        System.out.println("Backup of instance succeeded.");
    }

    private void restoreInstance(YarnClientApplication app, List<DFSResourceCoordinate> resources) throws IOException, YarnException {
        this.stopInstanceIfRunning();
        ApplicationId restorer = this.deployAM(app, resources, Mode.RESTORE);
        boolean restoreStart = Utils.waitForApplication(restorer, this.yarnClient, "Waiting for restore to start", this.ccRestPort);
        if (!restoreStart) {
            LOG.fatal((Object)"Restore failed to start");
            throw new YarnException();
        }
        boolean complete = this.waitForCompletion(restorer, "Restore in progress");
        if (!complete) {
            LOG.fatal((Object)"Restore failed- timeout waiting for completion");
            return;
        }
        System.out.println("Restoration of instance succeeded.");
    }

    private void stopInstance() throws IOException, YarnException {
        ApplicationId appId = this.getLockFile();
        this.readConfigParams(this.locateConfig());
        if (this.yarnClient.isInState(Service.STATE.INITED)) {
            this.yarnClient.start();
        }
        System.out.println("Stopping instance " + this.instanceName);
        if (!this.isRunning()) {
            LOG.fatal((Object)"AsterixDB instance by that name is stopped already");
            return;
        }
        try {
            String ccIp = Utils.getCCHostname(this.instanceName, this.conf);
            Utils.sendShutdownCall(ccIp, this.ccRestPort);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while trying to issue safe shutdown:", (Throwable)e);
        }
        String message = "Waiting for AsterixDB to shut down";
        boolean completed = this.waitForCompletion(appId, message);
        if (!completed && this.force) {
            LOG.warn((Object)"Instance failed to stop gracefully, now killing it");
            try {
                AsterixYARNClient.killApplication(appId, this.yarnClient);
                completed = true;
            }
            catch (YarnException e1) {
                LOG.fatal((Object)"Could not stop nor kill instance gracefully.", (Throwable)e1);
                return;
            }
        }
        if (completed) {
            this.deleteLockFile();
        }
    }

    private void deleteLockFile() throws IOException {
        Path lockPath;
        if (this.instanceName == null || this.instanceName == "") {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (fs.exists(lockPath = new Path(fs.getHomeDirectory(), CONF_DIR_REL + this.instanceName + '/' + instanceLock))) {
            fs.delete(lockPath, false);
        }
    }

    private boolean instanceExists() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + CONFIG_DEFAULT_NAME;
        Path dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
        return fs.exists(dstConf);
    }

    private boolean isRunning() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String pathSuffix = CONF_DIR_REL + this.instanceFolder + CONFIG_DEFAULT_NAME;
        Path dstConf = new Path(fs.getHomeDirectory(), pathSuffix);
        if (fs.exists(dstConf)) {
            Path lock = new Path(fs.getHomeDirectory(), CONF_DIR_REL + this.instanceFolder + instanceLock);
            return fs.exists(lock);
        }
        return false;
    }

    private ApplicationId getLockFile() throws IOException, YarnException {
        Path lockPath;
        if (this.instanceFolder == "") {
            throw new IllegalStateException("Instance name not given.");
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (!fs.exists(lockPath = new Path(fs.getHomeDirectory(), CONF_DIR_REL + this.instanceFolder + instanceLock))) {
            throw new YarnException("Instance appears to not be running. If you know it is, try using kill");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(lockPath)));
        String lockAppId = br.readLine();
        br.close();
        return ConverterUtils.toApplicationId((String)lockAppId);
    }

    public static ApplicationId getLockFile(String instanceName, Configuration conf) throws IOException {
        Path lockPath;
        if (instanceName == "") {
            throw new IllegalStateException("Instance name not given.");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(lockPath = new Path(fs.getHomeDirectory(), CONF_DIR_REL + instanceName + '/' + instanceLock))) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(lockPath)));
        String lockAppId = br.readLine();
        br.close();
        return ConverterUtils.toApplicationId((String)lockAppId);
    }

    private AsterixConfiguration locateConfig() throws FileNotFoundException, IOException {
        AsterixConfiguration configuration;
        String configPathBase = MERGED_PARAMETERS_PATH;
        if (this.baseConfig != null) {
            configuration = Utils.loadAsterixConfig(this.baseConfig);
            MERGED_PARAMETERS_PATH = configPathBase = new File(this.baseConfig).getParentFile().getAbsolutePath() + File.separator + PARAMS_DEFAULT_NAME;
        } else {
            configuration = Utils.loadAsterixConfig(DEFAULT_PARAMETERS_PATH);
        }
        return configuration;
    }

    private void readConfigParams(AsterixConfiguration configuration) {
        for (Property property : configuration.getProperty()) {
            if (property.getName().equalsIgnoreCase(CC_JAVA_OPTS_KEY)) {
                this.ccJavaOpts = property.getValue();
                continue;
            }
            if (property.getName().equalsIgnoreCase(NC_JAVA_OPTS_KEY)) {
                this.ncJavaOpts = property.getValue();
                continue;
            }
            if (!property.getName().equalsIgnoreCase(CC_REST_PORT_KEY)) continue;
            this.ccRestPort = Integer.parseInt(property.getValue());
        }
    }

    private void writeAsterixConfig(Cluster cluster) throws FileNotFoundException, IOException {
        String metadataNodeId = Utils.getMetadataNode(cluster).getId();
        String asterixInstanceName = this.instanceName;
        AsterixConfiguration configuration = this.locateConfig();
        this.readConfigParams(configuration);
        String version = Utils.getAsterixVersionFromClasspath();
        configuration.setVersion(version);
        configuration.setInstanceName(asterixInstanceName);
        ArrayList<Store> stores = new ArrayList<Store>();
        String storeDir = cluster.getStore().trim();
        for (Node node : cluster.getNode()) {
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            String[] nodeIdDevice = iodevices.split(",");
            StringBuilder nodeStores = new StringBuilder();
            for (int i = 0; i < nodeIdDevice.length; ++i) {
                nodeStores.append(nodeIdDevice[i] + File.separator + storeDir + ",");
            }
            nodeStores.deleteCharAt(nodeStores.length() - 1);
            stores.add(new Store(node.getId(), nodeStores.toString()));
        }
        configuration.setStore(stores);
        ArrayList<Coredump> coredump = new ArrayList<Coredump>();
        String coredumpdir = null;
        ArrayList<TransactionLogDir> txnLogDirs = new ArrayList<TransactionLogDir>();
        String txnLogDir = null;
        for (Node node : cluster.getNode()) {
            coredumpdir = node.getLogDir() == null ? cluster.getLogDir() : node.getLogDir();
            coredump.add(new Coredump(node.getId(), coredumpdir + "coredump" + File.separator));
            txnLogDir = node.getTxnLogDir() == null ? cluster.getTxnLogDir() : node.getTxnLogDir();
            txnLogDirs.add(new TransactionLogDir(node.getId(), txnLogDir + (txnLogDir.charAt(txnLogDir.length() - 1) == File.separatorChar ? File.separator : "") + "txnLogs" + File.separator));
        }
        configuration.setMetadataNode(metadataNodeId);
        configuration.setCoredump(coredump);
        configuration.setTransactionLogDir(txnLogDirs);
        try (FileOutputStream os = new FileOutputStream(MERGED_PARAMETERS_PATH);){
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{AsterixConfiguration.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)configuration, (OutputStream)os);
        }
    }

    private boolean waitForCompletion(ApplicationId appId, String message) throws YarnException, IOException {
        return Utils.waitForApplication(appId, this.yarnClient, message, this.ccRestPort);
    }

    private class DFSResourceCoordinate {
        String name;
        LocalResource res;
        Map<String, String> envs = new HashMap<String, String>(3);
    }

    public static enum Mode {
        INSTALL("install"),
        START("start"),
        STOP("stop"),
        KILL("kill"),
        DESTROY("destroy"),
        ALTER("alter"),
        LIBINSTALL("libinstall"),
        DESCRIBE("describe"),
        BACKUP("backup"),
        LSBACKUP("lsbackups"),
        RMBACKUP("rmbackup"),
        RESTORE("restore"),
        NOOP("");

        public final String alias;

        private Mode(String alias) {
            this.alias = alias;
        }

        public static Mode fromAlias(String a) {
            return STRING_TO_MODE.get(a.toLowerCase());
        }
    }
}

