/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.aoya;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.aoya.Utils;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.event.schema.yarnCluster.Cluster;
import org.apache.asterix.event.schema.yarnCluster.MasterNode;
import org.apache.asterix.event.schema.yarnCluster.Node;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.hyracks.bootstrap.NCApplication;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class AsterixApplicationMaster {
    private static final Log LOG;
    private static final String CLUSTER_DESC_PATH = "cluster-config.xml";
    private static final String ASTERIX_CONF_NAME = "asterix-configuration.xml";
    private static final String ASTERIX_ZIP_NAME = "asterix-server.zip";
    private static final int CC_MEMORY_MBS_DEFAULT = 1024;
    private static final int NC_MEMORY_MBS_DEFAULT = 1536;
    private static final String EXTERNAL_CC_JAVA_OPTS_DEFAULT = "-Xmx1024m";
    private static final String EXTERNAL_NC_JAVA_OPTS_DEFAULT = "-Xmx1536m";
    private static final String OBLITERATOR_CLASSNAME = "org.apache.asterix.aoya.Deleter";
    private static final String HDFS_BACKUP_CLASSNAME = "org.apache.asterix.aoya.HDFSBackup";
    private static final String NC_CLASSNAME = "org.apache.hyracks.control.nc.NCDriver";
    private static final String CC_CLASSNAME = "org.apache.hyracks.control.cc.CCDriver";
    private static final String JAVA_HOME;
    private boolean doneAllocating = false;
    private Configuration conf;
    private AMRMClientAsync<AMRMClient.ContainerRequest> resourceManager;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private ApplicationAttemptId appAttemptID;
    private String appMasterHostname = "";
    private int appMasterRpcPort = new Random().nextInt(16383);
    private String appMasterTrackingUrl = "";
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    private AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    private AtomicInteger numRequestedContainers = new AtomicInteger();
    private AtomicBoolean ccUp = new AtomicBoolean();
    private AtomicBoolean ccStarted = new AtomicBoolean();
    private Queue<Node> pendingNCs = new ArrayDeque<Node>();
    private String asterixZipPath = "";
    private long asterixZipTimestamp = 0L;
    private long asterixZipLen = 0L;
    private String asterixConfPath = "";
    private long asterixConfTimestamp = 0L;
    private long asterixConfLen = 0L;
    private String instanceConfPath = "";
    private String dfsBasePath;
    private int numTotalContainers = 0;
    private Map<String, LocalResource> localResources = new HashMap<String, LocalResource>();
    private Cluster clusterDesc = null;
    private MasterNode cC = null;
    private String ccJavaOpts = null;
    private int ccMem = 0;
    private String ncJavaOpts = null;
    private int ncMem = 0;
    private volatile boolean done;
    private volatile boolean success;
    private boolean obliterate = false;
    private Path appMasterJar = null;
    private boolean backup = false;
    long backupTimestamp;
    String snapName;
    private boolean restore = false;
    private boolean initial = false;
    private List<Thread> launchThreads = new CopyOnWriteArrayList<Thread>();

    public static void main(String[] args) {
        boolean result = false;
        try {
            AsterixApplicationMaster appMaster = new AsterixApplicationMaster();
            LOG.info((Object)"Initializing ApplicationMaster");
            appMaster.setEnvs(appMaster.setArgs(args));
            boolean doRun = appMaster.init();
            if (!doRun) {
                System.exit(0);
            }
            result = appMaster.run();
        }
        catch (Exception e) {
            LOG.fatal((Object)"Error running ApplicationMaster", (Throwable)e);
            System.exit(1);
        }
        if (result) {
            LOG.info((Object)"Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info((Object)"Application Master failed. exiting");
            System.exit(2);
        }
    }

    private void dumpOutDebugInfo() {
        LOG.info((Object)"Dump debug output");
        Map<String, String> envs = System.getenv();
        envs.forEach((key, value) -> {
            LOG.info((Object)("System env: key=" + key + ", val=" + value));
            System.out.println("System env: key=" + key + ", val=" + value);
        });
        String cmd = "ls -alhLR";
        Runtime run = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = run.exec(cmd);
            pr.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            while ((line = buf.readLine()) != null) {
                LOG.info((Object)("System CWD content: " + line));
                System.out.println("System CWD content: " + line);
            }
            buf.close();
        }
        catch (IOException e) {
            LOG.info((Object)e);
        }
        catch (InterruptedException e) {
            LOG.info((Object)e);
        }
    }

    public AsterixApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    public CommandLine setArgs(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("help", false, "Print usage");
        opts.addOption("initial", false, "Initialize existing Asterix instance.");
        opts.addOption("obliterate", false, "Delete asterix instance completely.");
        opts.addOption("backup", false, "Back up AsterixDB instance");
        opts.addOption("restore", true, "Restore an AsterixDB instance");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
        }
        if (cliParser.hasOption("obliterate")) {
            this.obliterate = true;
        }
        if (cliParser.hasOption("initial")) {
            this.initial = true;
        }
        if (cliParser.hasOption("backup")) {
            this.backup = true;
            this.backupTimestamp = System.currentTimeMillis();
        }
        if (cliParser.hasOption("restore")) {
            this.restore = true;
            this.snapName = cliParser.getOptionValue("restore");
            LOG.info((Object)this.snapName);
        }
        return cliParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEnvs(CommandLine cliParser) {
        File hadoopConfDir;
        Map<String, String> envs = System.getenv();
        if (envs.containsKey("HADOOP_CONF_DIR") && (hadoopConfDir = new File(envs.get("HADOOP_CONF_DIR"))).isDirectory()) {
            for (File config : hadoopConfDir.listFiles()) {
                if (!config.getName().matches("^.*(xml)$")) continue;
                this.conf.addResource(new Path(config.getAbsolutePath()));
            }
        }
        if (!envs.containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Environment is not set correctly- please check client submission settings");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
        } else {
            ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
        }
        if (!(envs.containsKey("APP_SUBMIT_TIME_ENV") && envs.containsKey(ApplicationConstants.Environment.NM_HOST.name()) && envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name()) && envs.containsKey(ApplicationConstants.Environment.NM_PORT.name()))) {
            throw new IllegalArgumentException("Environment is not set correctly- please check client submission settings");
        }
        System.setProperty("AsterixConfigFileName", envs.get("PWD") + File.separator + "bin" + File.separator + ASTERIX_CONF_NAME);
        LOG.info((Object)("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId()));
        this.asterixZipPath = envs.get("TARLOCATION");
        this.asterixZipTimestamp = Long.parseLong(envs.get("TARTIMESTAMP"));
        this.asterixZipLen = Long.parseLong(envs.get("TARLEN"));
        this.asterixConfPath = envs.get("CONFLOCATION");
        this.asterixConfTimestamp = Long.parseLong(envs.get("CONFTIMESTAMP"));
        this.asterixConfLen = Long.parseLong(envs.get("CONFLEN"));
        this.instanceConfPath = envs.get("INSTANCESTORE");
        this.appMasterJar = envs.get("APPLICATIONMASTERJARLOCATION") != null && !envs.get("APPLICATIONMASTERJARLOCATION").endsWith(File.separator) ? new Path(envs.get("APPLICATIONMASTERJARLOCATION")) : null;
        this.dfsBasePath = envs.get("DFSBASE");
        if (envs.get("RMADDRESS") != null) {
            this.conf.set("yarn.resourcemanager.address", envs.get("RMADDRESS"));
            LOG.info((Object)("RM Address: " + envs.get("RMADDRESS")));
        }
        if (envs.get("RMADDRESS") != null) {
            this.conf.set("yarn.resourcemanager.scheduler.address", envs.get("RMSCHEDULERADDRESS"));
        }
        this.ccJavaOpts = envs.get("CCJAVAOPTS");
        if (this.ccJavaOpts == null) {
            this.ccJavaOpts = EXTERNAL_CC_JAVA_OPTS_DEFAULT;
        }
        this.ncJavaOpts = envs.get("NCJAVAOPTS");
        if (this.ncJavaOpts == null) {
            this.ncJavaOpts = EXTERNAL_NC_JAVA_OPTS_DEFAULT;
        }
        LOG.info((Object)("Path suffix: " + this.instanceConfPath));
    }

    public boolean init() throws ParseException, IOException, AsterixException, YarnException {
        try {
            this.localizeDFSResources();
            this.clusterDesc = Utils.parseYarnClusterConfig(CLUSTER_DESC_PATH);
            this.cC = this.clusterDesc.getMasterNode();
            this.appMasterTrackingUrl = "http://" + this.cC.getClientIp() + ":" + this.cC.getClientPort() + "/";
            this.distributeAsterixConfig();
            LOG.debug((Object)("config file loc: " + System.getProperty("AsterixConfigFileName")));
        }
        catch (FileNotFoundException | IllegalStateException e) {
            LOG.error((Object)"Could not deserialize Cluster Config from disk- aborting!");
            LOG.error((Object)e);
            throw e;
        }
        return true;
    }

    private void distributeAsterixConfig() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        String pathSuffix = this.instanceConfPath + File.separator + ASTERIX_CONF_NAME;
        Path dst = new Path(this.dfsBasePath, pathSuffix);
        URI paramLocation = dst.toUri();
        FileStatus paramFileStatus = fs.getFileStatus(dst);
        Long paramLen = paramFileStatus.getLen();
        Long paramTimestamp = paramFileStatus.getModificationTime();
        LocalResource asterixParamLoc = (LocalResource)Records.newRecord(LocalResource.class);
        asterixParamLoc.setType(LocalResourceType.FILE);
        asterixParamLoc.setVisibility(LocalResourceVisibility.PRIVATE);
        asterixParamLoc.setResource(ConverterUtils.getYarnUrlFromURI((URI)paramLocation));
        asterixParamLoc.setTimestamp(paramTimestamp.longValue());
        asterixParamLoc.setSize(paramLen.longValue());
        this.localResources.put(ASTERIX_CONF_NAME, asterixParamLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestResources(Cluster c) throws YarnException, UnknownHostException {
        int deathClock;
        this.ccMem = c.getCcContainerMem() != null ? Integer.parseInt(c.getCcContainerMem()) : 1024;
        this.ncMem = c.getNcContainerMem() != null ? Integer.parseInt(c.getNcContainerMem()) : 1024;
        int numNodes = 0;
        AMRMClient.ContainerRequest ccAsk = this.hostToRequest(this.cC.getClusterIp(), true);
        this.resourceManager.addContainerRequest(ccAsk);
        LOG.info((Object)("Asked for CC: " + Arrays.toString(ccAsk.getNodes().toArray())));
        ++numNodes;
        for (deathClock = 60; !this.ccUp.get() && deathClock > 0; --deathClock) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.debug((Object)ex);
            }
        }
        if (deathClock == 0 && !this.ccUp.get()) {
            throw new YarnException("Couldn't allocate container for CC. Abort!");
        }
        LOG.info((Object)"Waiting for CC process to start");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            LOG.debug((Object)ex);
        }
        for (Node n : c.getNode()) {
            this.resourceManager.addContainerRequest(this.hostToRequest(n.getClusterIp(), false));
            LOG.info((Object)("Asked for NC: " + n.getClusterIp()));
            ++numNodes;
            Queue<Node> queue = this.pendingNCs;
            synchronized (queue) {
                this.pendingNCs.add(n);
            }
        }
        LOG.info((Object)"Requested all NCs and CCs. Wait for things to settle!");
        this.numRequestedContainers.set(numNodes);
        this.numTotalContainers = numNodes;
        this.doneAllocating = true;
    }

    private AMRMClient.ContainerRequest hostToRequest(String host, boolean cc) throws UnknownHostException {
        InetAddress hostIp = InetAddress.getByName(host);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(0);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        if (cc) {
            capability.setMemory(this.ccMem);
        } else {
            capability.setMemory(this.ncMem);
        }
        String[] hosts = new String[]{hostIp.getHostName()};
        LOG.info((Object)("IP addr: " + host + " resolved to " + hostIp.getHostName()));
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, hosts, null, pri, false);
        LOG.info((Object)("Requested host ask: " + request.getNodes()));
        return request;
    }

    boolean containerIsCC(Container c) {
        String containerHost = c.getNodeId().getHost();
        try {
            InetAddress containerIp = InetAddress.getByName(containerHost);
            LOG.info((Object)containerIp.getCanonicalHostName());
            InetAddress ccIp = InetAddress.getByName(this.cC.getClusterIp());
            LOG.info((Object)ccIp.getCanonicalHostName());
            return containerIp.getCanonicalHostName().equals(ccIp.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    Node containerToNode(Container c, Cluster cl) throws UnknownHostException {
        String containerHost = c.getNodeId().getHost();
        InetAddress containerIp = InetAddress.getByName(containerHost);
        LOG.info((Object)("Resolved Container IP: " + containerIp));
        for (Node node : cl.getNode()) {
            InetAddress nodeIp = InetAddress.getByName(node.getClusterIp());
            LOG.info((Object)(nodeIp + "?=" + containerIp));
            if (!nodeIp.equals(containerIp)) continue;
            return node;
        }
        throw new UnknownHostException("Could not resolve container" + containerHost + " to node");
    }

    private void localizeDFSResources() throws IOException {
        if (this.obliterate || this.backup || this.restore) {
            if (this.appMasterJar == null || "".equals(this.appMasterJar)) {
                if (!this.conf.getBoolean("yarn.is.minicluster", false)) {
                    throw new IllegalStateException("AM jar not provided in environment.");
                }
                return;
            }
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            FileStatus appMasterJarStatus = fs.getFileStatus(this.appMasterJar);
            LocalResource obliteratorJar = (LocalResource)Records.newRecord(LocalResource.class);
            obliteratorJar.setType(LocalResourceType.FILE);
            obliteratorJar.setVisibility(LocalResourceVisibility.PRIVATE);
            obliteratorJar.setResource(ConverterUtils.getYarnUrlFromPath((Path)this.appMasterJar));
            obliteratorJar.setTimestamp(appMasterJarStatus.getModificationTime());
            obliteratorJar.setSize(appMasterJarStatus.getLen());
            this.localResources.put("asterix-yarn.jar", obliteratorJar);
            LOG.info(this.localResources.values());
            return;
        }
        LocalResource asterixZip = (LocalResource)Records.newRecord(LocalResource.class);
        asterixZip.setType(LocalResourceType.ARCHIVE);
        asterixZip.setVisibility(LocalResourceVisibility.PRIVATE);
        try {
            asterixZip.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(this.asterixZipPath)));
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Error locating Asterix zip in env, path=" + this.asterixZipPath));
            throw new IOException(e);
        }
        asterixZip.setTimestamp(this.asterixZipTimestamp);
        asterixZip.setSize(this.asterixZipLen);
        this.localResources.put(ASTERIX_ZIP_NAME, asterixZip);
        LocalResource asterixConf = (LocalResource)Records.newRecord(LocalResource.class);
        asterixConf.setType(LocalResourceType.FILE);
        asterixConf.setVisibility(LocalResourceVisibility.PRIVATE);
        try {
            asterixConf.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(this.asterixConfPath)));
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Error locating Asterix config in env, path=" + this.asterixConfPath));
            throw new IOException(e);
        }
        asterixConf.setTimestamp(this.asterixConfTimestamp);
        asterixConf.setSize(this.asterixConfLen);
        this.localResources.put(CLUSTER_DESC_PATH, asterixConf);
        try {
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            Path p = new Path(this.dfsBasePath, this.instanceConfPath + File.separator + "library" + "/");
            if (fs.exists(p)) {
                FileStatus[] dataverses;
                for (FileStatus d : dataverses = fs.listStatus(p)) {
                    FileStatus[] libraries;
                    if (!d.isDirectory()) {
                        throw new IOException("Library configuration directory structure is incorrect");
                    }
                    for (FileStatus l : libraries = fs.listStatus(d.getPath())) {
                        if (l.isDirectory()) {
                            throw new IOException("Library configuration directory structure is incorrect");
                        }
                        LocalResource lr = (LocalResource)Records.newRecord(LocalResource.class);
                        lr.setResource(ConverterUtils.getYarnUrlFromURI((URI)l.getPath().toUri()));
                        lr.setSize(l.getLen());
                        lr.setTimestamp(l.getModificationTime());
                        lr.setType(LocalResourceType.ARCHIVE);
                        lr.setVisibility(LocalResourceVisibility.PRIVATE);
                        this.localResources.put("library/" + d.getPath().getName() + "/" + l.getPath().getName().split("\\.")[0], lr);
                        LOG.info((Object)("Found library: " + l.getPath().toString()));
                        LOG.info((Object)l.getPath().getName());
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)"No external libraries present");
        }
        LOG.info(this.localResources.values());
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public boolean run() throws YarnException, IOException {
        LOG.info((Object)"Starting ApplicationMaster");
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.resourceManager = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener);
        this.resourceManager.init(this.conf);
        this.resourceManager.start();
        this.containerListener = new NMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        try {
            this.appMasterHostname = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException uhe) {
            this.appMasterHostname = uhe.toString();
        }
        RegisterApplicationMasterResponse response = this.resourceManager.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        int maxMem = response.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        try {
            this.requestResources(this.clusterDesc);
        }
        catch (YarnException e) {
            LOG.error((Object)("Could not allocate resources properly:" + e.getMessage()));
            this.done = true;
            throw e;
        }
        while (!this.done) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.finish();
        return this.success;
    }

    private void finish() {
        FinalApplicationStatus appStatus;
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Exception thrown in thread join: " + e.getMessage()));
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                LOG.error((Object)errors.toString());
            }
        }
        LOG.info((Object)"Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info((Object)"Application completed. Signalling finish to RM");
        String appMessage = null;
        this.success = true;
        if (this.numFailedContainers.get() == 0 && this.numCompletedContainers.get() == this.numTotalContainers) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            this.success = false;
        }
        try {
            this.resourceManager.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            LOG.error((Object)"Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to unregister application", (Throwable)e);
        }
        this.done = true;
        this.resourceManager.stop();
    }

    static {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%-6r [%p] %c - %m%n")));
        LOG = LogFactory.getLog(AsterixApplicationMaster.class);
        JAVA_HOME = System.getProperty("java.home");
    }

    private class LaunchAsterixContainer
    implements Runnable {
        final Container container;
        final NMCallbackHandler containerListener;

        public LaunchAsterixContainer(Container lcontainer, NMCallbackHandler containerListener) {
            this.container = lcontainer;
            this.containerListener = containerListener;
        }

        @Override
        public void run() {
            LOG.info((Object)("Setting up container launch container for containerid=" + this.container.getId()));
            ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            ctx.setLocalResources(AsterixApplicationMaster.this.localResources);
            LOG.info((Object)"Set the environment for the node");
            HashMap<String, String> env = new HashMap<String, String>();
            StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$()).append(File.pathSeparatorChar).append("." + File.pathSeparatorChar + "*");
            for (String c : AsterixApplicationMaster.this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                classPathEnv.append(File.pathSeparatorChar);
                classPathEnv.append(c.trim());
            }
            classPathEnv.append('.').append(File.pathSeparatorChar).append("log4j.properties");
            if (AsterixApplicationMaster.this.conf.getBoolean("yarn.is.minicluster", false)) {
                classPathEnv.append(System.getProperty("path.separator"));
                classPathEnv.append(System.getProperty("java.class.path"));
                env.put("HADOOP_CONF_DIR", System.getProperty("user.dir") + File.separator + "target" + File.separator);
            }
            env.put("CLASSPATH", classPathEnv.toString());
            ctx.setEnvironment(env);
            LOG.info((Object)ctx.getEnvironment().toString());
            List<String> startCmd = null;
            if (AsterixApplicationMaster.this.obliterate) {
                LOG.debug((Object)"AM in obliterate mode");
                startCmd = this.produceObliterateCommand(this.container);
            } else if (AsterixApplicationMaster.this.backup) {
                startCmd = this.produceBackupCommand(this.container);
                LOG.debug((Object)"AM in backup mode");
            } else if (AsterixApplicationMaster.this.restore) {
                startCmd = this.produceRestoreCommand(this.container);
                LOG.debug((Object)"AM in restore mode");
            } else {
                startCmd = this.produceStartCmd(this.container);
            }
            if (startCmd == null || startCmd.size() == 0) {
                LOG.fatal((Object)"Could not map one or more NCs to NM container hosts- aborting!");
                return;
            }
            for (String s : startCmd) {
                LOG.info((Object)("Command to execute: " + s));
            }
            ctx.setCommands(startCmd);
            this.containerListener.addContainer(this.container.getId(), this.container);
            AsterixApplicationMaster.this.nmClientAsync.startContainerAsync(this.container, ctx);
        }

        private List<String> produceStartCmd(Container container) {
            ArrayList<String> commands = new ArrayList<String>();
            ArrayList<String> vargs = new ArrayList<String>(5);
            vargs.add(JAVA_HOME + File.separator + "bin" + File.separator + "java");
            vargs.add("-classpath 'asterix-server.zip" + File.separator + "repo" + File.separator + "*'");
            vargs.add("-Dapp.repo=asterix-server.zip" + File.separator + "repo" + File.separator);
            if (AsterixApplicationMaster.this.containerIsCC(container) && !AsterixApplicationMaster.this.ccStarted.get()) {
                LOG.info((Object)("CC found on container" + container.getNodeId().getHost()));
                vargs.add(AsterixApplicationMaster.this.ccJavaOpts);
                vargs.add(AsterixApplicationMaster.CC_CLASSNAME);
                vargs.add("-app-class " + CCApplication.class.getName());
                vargs.add("-address " + AsterixApplicationMaster.this.cC.getClusterIp());
                vargs.add("-client-listen-address " + AsterixApplicationMaster.this.cC.getClientIp());
                if (AsterixApplicationMaster.this.clusterDesc.getHeartbeatPeriod() != null) {
                    vargs.add("-heartbeat-period " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getHeartbeatPeriod().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getMaxHeartbeatLapsePeriods() != null) {
                    vargs.add("-heartbeat-max-misses " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getMaxHeartbeatLapsePeriods().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getProfileDumpPeriod() != null) {
                    vargs.add("-profile-dump-period " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getProfileDumpPeriod().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getJobHistorySize() != null) {
                    vargs.add("-job-history-size " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getJobHistorySize().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getResultTimeToLive() != null) {
                    vargs.add("-result-ttl " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getResultTimeToLive().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getResultSweepThreshold() != null) {
                    vargs.add("-result-sweep-threshold " + String.valueOf(AsterixApplicationMaster.this.clusterDesc.getResultSweepThreshold().intValue()));
                }
                if (AsterixApplicationMaster.this.clusterDesc.getCcRoot() != null) {
                    vargs.add("-root-dir " + AsterixApplicationMaster.this.clusterDesc.getCcRoot());
                }
                AsterixApplicationMaster.this.ccStarted.set(true);
            } else {
                try {
                    Node local = AsterixApplicationMaster.this.containerToNode(container, AsterixApplicationMaster.this.clusterDesc);
                    LOG.info((Object)("Attempting to start NC on host " + local.getId()));
                    String iodevice = local.getIodevices();
                    if (iodevice == null) {
                        iodevice = AsterixApplicationMaster.this.clusterDesc.getIodevices();
                    }
                    vargs.add(AsterixApplicationMaster.this.ncJavaOpts);
                    vargs.add(AsterixApplicationMaster.NC_CLASSNAME);
                    vargs.add("-app-class " + NCApplication.class.getName());
                    vargs.add("-node-id " + local.getId());
                    vargs.add("-cluster-address " + AsterixApplicationMaster.this.cC.getClusterIp());
                    vargs.add("-iodevices " + iodevice);
                    vargs.add("-address " + local.getClusterIp());
                    vargs.add("-data-listen-address " + local.getClusterIp());
                    vargs.add("-result-listen-address " + local.getClusterIp());
                    if (AsterixApplicationMaster.this.initial) {
                        vargs.add("-initial-run ");
                    }
                }
                catch (UnknownHostException e) {
                    LOG.error((Object)("Unable to find NC or CC configured for host: " + container.getId() + " " + e));
                }
            }
            vargs.add("1><LOG_DIR>" + File.separator + "stdout");
            vargs.add("2><LOG_DIR>" + File.separator + "stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            commands.add(command.toString());
            LOG.error((Object)Arrays.toString(commands.toArray()));
            return commands;
        }

        private List<String> produceObliterateCommand(Container container) {
            Node local = null;
            List<String> iodevices = null;
            try {
                local = AsterixApplicationMaster.this.containerToNode(container, AsterixApplicationMaster.this.clusterDesc);
                iodevices = local.getIodevices() == null ? Arrays.asList(AsterixApplicationMaster.this.clusterDesc.getIodevices().split(",", -1)) : Arrays.asList(local.getIodevices().split(",", -1));
            }
            catch (UnknownHostException e) {
                if (!AsterixApplicationMaster.this.containerIsCC(container)) {
                    LOG.error((Object)("Unable to find NC configured for host: " + container.getId() + e));
                    return null;
                }
                return Arrays.asList("");
            }
            StringBuilder classPathEnv = new StringBuilder("").append("*");
            classPathEnv.append(File.pathSeparatorChar).append("log4j.properties");
            ArrayList<String> commands = new ArrayList<String>();
            Vector<String> vargs = new Vector<String>(5);
            vargs.add(JAVA_HOME + File.separator + "bin" + File.separator + "java");
            vargs.add("-cp " + classPathEnv.toString());
            vargs.add(AsterixApplicationMaster.OBLITERATOR_CLASSNAME);
            for (String s : iodevices) {
                vargs.add(s + File.separator + AsterixApplicationMaster.this.clusterDesc.getStore());
                LOG.debug((Object)("Deleting from: " + s));
                if (iodevices.indexOf(s) != 0) continue;
                vargs.add(AsterixApplicationMaster.this.clusterDesc.getTxnLogDir() + "txnLogs" + File.separator);
                LOG.debug((Object)("Deleting logs from: " + AsterixApplicationMaster.this.clusterDesc.getTxnLogDir()));
            }
            vargs.add("1><LOG_DIR>" + File.separator + "stdout");
            vargs.add("2><LOG_DIR>" + File.separator + "stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            commands.add(command.toString());
            return commands;
        }

        private List<String> produceBackupCommand(Container container) {
            Node local = null;
            List<String> iodevices = null;
            try {
                local = AsterixApplicationMaster.this.containerToNode(container, AsterixApplicationMaster.this.clusterDesc);
                iodevices = local.getIodevices() == null ? Arrays.asList(AsterixApplicationMaster.this.clusterDesc.getIodevices().split(",", -1)) : Arrays.asList(local.getIodevices().split(",", -1));
            }
            catch (UnknownHostException e) {
                if (!AsterixApplicationMaster.this.containerIsCC(container)) {
                    LOG.error((Object)("Unable to find NC configured for host: " + container.getId() + e));
                    return null;
                }
                return Arrays.asList("");
            }
            StringBuilder classPathEnv = new StringBuilder("").append("." + File.separator + "*");
            for (String c : AsterixApplicationMaster.this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                classPathEnv.append(File.pathSeparatorChar);
                classPathEnv.append(c.trim());
            }
            classPathEnv.append(File.pathSeparatorChar).append("." + File.separator + "log4j.properties");
            ArrayList<String> commands = new ArrayList<String>();
            Vector<String> vargs = new Vector<String>(5);
            vargs.add(JAVA_HOME + File.separator + "bin" + File.separator + "java");
            vargs.add("-cp " + classPathEnv.toString());
            vargs.add(AsterixApplicationMaster.HDFS_BACKUP_CLASSNAME);
            vargs.add("-backup");
            String dstBase = AsterixApplicationMaster.this.instanceConfPath + "backups" + "/" + AsterixApplicationMaster.this.backupTimestamp + "/" + local.getId();
            try {
                this.createBackupFolder(dstBase);
            }
            catch (IOException e) {
                return null;
            }
            for (String s : iodevices) {
                List<String> list = Arrays.asList(s.split("\\/"));
                StringBuilder dst = new StringBuilder().append(dstBase);
                for (String io : list) {
                    dst.append(io);
                    if (list.indexOf(io) == list.size() - 1) continue;
                    dst.append("_");
                }
                dst.append("/");
                vargs.add(s + File.separator + AsterixApplicationMaster.this.clusterDesc.getStore() + "," + dst);
                LOG.debug((Object)("Backing up from: " + s));
                if (iodevices.indexOf(s) != 0) continue;
                LOG.debug((Object)("Backing up logs from: " + AsterixApplicationMaster.this.clusterDesc.getTxnLogDir()));
                vargs.add(AsterixApplicationMaster.this.clusterDesc.getTxnLogDir() + "txnLogs" + File.separator + "," + dst);
            }
            LOG.debug((Object)("Backing up to: " + AsterixApplicationMaster.this.instanceConfPath + "backups" + "/" + local.getId()));
            vargs.add("1><LOG_DIR>" + File.separator + "stdout");
            vargs.add("2><LOG_DIR>" + File.separator + "stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            commands.add(command.toString());
            return commands;
        }

        private void createBackupFolder(String path) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)AsterixApplicationMaster.this.conf);
            Path backupFolder = new Path(path);
            fs.mkdirs(backupFolder);
        }

        private List<String> produceRestoreCommand(Container container) {
            if (AsterixApplicationMaster.this.containerIsCC(container)) {
                ArrayList<String> blank = new ArrayList<String>();
                blank.add("");
                return blank;
            }
            Node local = null;
            List<String> iodevices = null;
            try {
                local = AsterixApplicationMaster.this.containerToNode(container, AsterixApplicationMaster.this.clusterDesc);
                iodevices = local.getIodevices() == null ? Arrays.asList(AsterixApplicationMaster.this.clusterDesc.getIodevices().split(",", -1)) : Arrays.asList(local.getIodevices().split(",", -1));
            }
            catch (UnknownHostException e) {
                if (!AsterixApplicationMaster.this.containerIsCC(container)) {
                    LOG.error((Object)("Unable to find NC configured for host: " + container.getId() + e));
                    return null;
                }
                return Arrays.asList("");
            }
            StringBuilder classPathEnv = new StringBuilder("").append("." + File.separator + "*");
            for (String c : AsterixApplicationMaster.this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                classPathEnv.append(File.pathSeparatorChar);
                classPathEnv.append(c.trim());
            }
            classPathEnv.append(File.pathSeparatorChar).append("." + File.separator + "log4j.properties");
            ArrayList<String> commands = new ArrayList<String>();
            Vector<String> vargs = new Vector<String>(5);
            vargs.add(JAVA_HOME + File.separator + "bin" + File.separator + "java");
            vargs.add("-cp " + classPathEnv.toString());
            vargs.add(AsterixApplicationMaster.HDFS_BACKUP_CLASSNAME);
            vargs.add("-restore");
            String srcBase = AsterixApplicationMaster.this.instanceConfPath + "backups" + "/" + Long.parseLong(AsterixApplicationMaster.this.snapName) + "/" + local.getId();
            for (String s : iodevices) {
                List<String> list = Arrays.asList(s.split("\\/"));
                StringBuilder src = new StringBuilder().append(srcBase);
                for (String io : list) {
                    src.append(io);
                    if (list.indexOf(io) == list.size() - 1) continue;
                    src.append("_");
                }
                src.append("/");
                try {
                    FileStatus[] backups;
                    FileSystem fs = FileSystem.get((Configuration)AsterixApplicationMaster.this.conf);
                    for (FileStatus b : backups = fs.listStatus(new Path(src.toString()))) {
                        if (b.getPath().toString().contains("txnLogs") || b.getPath().toString().contains(File.separator + "root_metadata")) continue;
                        vargs.add(b.getPath() + "," + s + File.separator + AsterixApplicationMaster.this.clusterDesc.getStore());
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Could not stat backup directory in DFS");
                }
                vargs.add(src + "," + s + AsterixApplicationMaster.this.clusterDesc.getStore());
                LOG.debug((Object)("Restoring from: " + s));
                if (iodevices.indexOf(s) != 0) continue;
                vargs.add(src + "txnLogs" + File.separator + "," + AsterixApplicationMaster.this.clusterDesc.getTxnLogDir() + File.separator);
                LOG.debug((Object)("Restoring logs from: " + AsterixApplicationMaster.this.clusterDesc.getTxnLogDir()));
            }
            LOG.debug((Object)("Restoring to: " + AsterixApplicationMaster.this.instanceConfPath + "backups" + "/" + local.getId()));
            vargs.add("1><LOG_DIR>" + File.separator + "stdout");
            vargs.add("2><LOG_DIR>" + File.separator + "stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            commands.add(command.toString());
            return commands;
        }
    }

    private class NMCallbackHandler
    implements NMClientAsync.CallbackHandler {
        private ConcurrentMap<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();

        private NMCallbackHandler() {
        }

        public void addContainer(ContainerId containerId, Container container) {
            this.containers.putIfAbsent(containerId, container);
        }

        public void onContainerStopped(ContainerId containerId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Succeeded to stop Container " + containerId));
            }
            this.containers.remove(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Container Status: id=" + containerId + ", status=" + containerStatus));
            }
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            Container container;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Succeeded to start Container " + containerId));
            }
            if ((container = (Container)this.containers.get(containerId)) != null) {
                AsterixApplicationMaster.this.nmClientAsync.getContainerStatusAsync(containerId, container.getNodeId());
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to start Container " + containerId));
            this.containers.remove(containerId);
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to query the status of Container " + containerId));
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to stop Container " + containerId));
            this.containers.remove(containerId);
        }
    }

    private class RMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        private RMCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            LOG.info((Object)("Got response from RM for container ask, completedCnt=" + completedContainers.size()));
            for (ContainerStatus containerStatus : completedContainers) {
                LOG.info((Object)("Got container status for containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics()));
                if (containerStatus.getState() != ContainerState.COMPLETE) {
                    throw new IllegalStateException("Non-completed container given as completed by RM.");
                }
                int exitStatus = containerStatus.getExitStatus();
                if (0 != exitStatus) {
                    AsterixApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    AsterixApplicationMaster.this.numFailedContainers.incrementAndGet();
                    continue;
                }
                AsterixApplicationMaster.this.numCompletedContainers.incrementAndGet();
                LOG.info((Object)("Container completed successfully., containerId=" + containerStatus.getContainerId()));
            }
            if (AsterixApplicationMaster.this.numCompletedContainers.get() + AsterixApplicationMaster.this.numFailedContainers.get() == AsterixApplicationMaster.this.numAllocatedContainers.get() && AsterixApplicationMaster.this.doneAllocating) {
                AsterixApplicationMaster.this.done = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info((Object)("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size()));
            AsterixApplicationMaster.this.numAllocatedContainers.addAndGet(allocatedContainers.size());
            for (Container allocatedContainer : allocatedContainers) {
                Queue queue = AsterixApplicationMaster.this.pendingNCs;
                synchronized (queue) {
                    try {
                        if (!AsterixApplicationMaster.this.pendingNCs.contains(AsterixApplicationMaster.this.containerToNode(allocatedContainer, AsterixApplicationMaster.this.clusterDesc)) && AsterixApplicationMaster.this.ccUp.get()) {
                            AsterixApplicationMaster.this.nmClientAsync.stopContainerAsync(allocatedContainer.getId(), allocatedContainer.getNodeId());
                            continue;
                        }
                    }
                    catch (UnknownHostException ex) {
                        LOG.error((Object)"Unknown host allocated for us by RM- this shouldn't happen.", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemory()));
                LaunchAsterixContainer runnableLaunchContainer = new LaunchAsterixContainer(allocatedContainer, AsterixApplicationMaster.this.containerListener);
                Thread launchThread = new Thread((Runnable)runnableLaunchContainer, "Asterix CC/NC");
                LOG.info((Object)("Allocated: " + allocatedContainer.getNodeId().getHost()));
                LOG.info((Object)("CC : " + AsterixApplicationMaster.this.cC.getId()));
                Queue queue2 = AsterixApplicationMaster.this.pendingNCs;
                synchronized (queue2) {
                    try {
                        if (AsterixApplicationMaster.this.ccUp.get()) {
                            AsterixApplicationMaster.this.pendingNCs.remove(AsterixApplicationMaster.this.containerToNode(allocatedContainer, AsterixApplicationMaster.this.clusterDesc));
                        }
                    }
                    catch (UnknownHostException ex) {
                        LOG.error((Object)"Unknown host allocated for us by RM- this shouldn't happen.", (Throwable)ex);
                    }
                }
                if (AsterixApplicationMaster.this.containerIsCC(allocatedContainer)) {
                    AsterixApplicationMaster.this.ccUp.set(true);
                }
                AsterixApplicationMaster.this.launchThreads.add(launchThread);
                launchThread.start();
            }
        }

        public void onShutdownRequest() {
            LOG.info((Object)"AM shutting down per request");
            AsterixApplicationMaster.this.done = true;
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
        }

        public float getProgress() {
            if (!AsterixApplicationMaster.this.doneAllocating) {
                return 0.0f;
            }
            return 0.5f;
        }

        public void onError(Throwable arg0) {
            LOG.error((Object)("Fatal Error recieved by AM: " + arg0));
            AsterixApplicationMaster.this.done = true;
        }
    }
}

