/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.MurmurHash128Bit;

public abstract class AbstractOperationCallback {
    private static final long SEED = 0L;
    protected final DatasetId datasetId;
    protected final int[] primaryKeyFields;
    protected final ITransactionContext txnCtx;
    protected final ILockManager lockManager;
    protected final long[] longHashes;

    public AbstractOperationCallback(DatasetId datasetId, int[] primaryKeyFields, ITransactionContext txnCtx, ILockManager lockManager) {
        this.datasetId = datasetId;
        this.primaryKeyFields = primaryKeyFields;
        this.txnCtx = txnCtx;
        this.lockManager = lockManager;
        this.longHashes = new long[2];
    }

    public int computePrimaryKeyHashValue(ITupleReference tuple, int[] primaryKeyFields) {
        MurmurHash128Bit.hash3_x64_128((ITupleReference)tuple, (int[])primaryKeyFields, (long)0L, (long[])this.longHashes);
        return Math.abs((int)this.longHashes[0]);
    }

    public void incrementLocalNumActiveOperations() {
        this.txnCtx.incrementNumActiveOperations();
    }

    public void decrementLocalNumActiveOperations() {
        this.txnCtx.decrementNumActiveOperations();
    }
}

