/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.replication;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.replication.Replica;
import org.apache.hyracks.api.application.IClusterLifecycleListener;

public class ReplicaEvent {
    Replica replica;
    IClusterLifecycleListener.ClusterEventType eventType;

    public ReplicaEvent(Replica replica, IClusterLifecycleListener.ClusterEventType eventType) {
        this.replica = replica;
        this.eventType = eventType;
    }

    public Replica getReplica() {
        return this.replica;
    }

    public void setReplica(Replica replica) {
        this.replica = replica;
    }

    public IClusterLifecycleListener.ClusterEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(IClusterLifecycleListener.ClusterEventType eventType) {
        this.eventType = eventType;
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.replica.writeFields(dos);
        dos.writeInt(this.eventType.ordinal());
    }

    public static ReplicaEvent create(DataInput input) throws IOException {
        Replica replica = Replica.create(input);
        IClusterLifecycleListener.ClusterEventType eventType = IClusterLifecycleListener.ClusterEventType.values()[input.readInt()];
        ReplicaEvent event = new ReplicaEvent(replica, eventType);
        return event;
    }
}

