/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IDatasetMemoryManager;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;

public class DatasetMemoryManager
implements IDatasetMemoryManager {
    private static final Logger LOGGER = Logger.getLogger(DatasetMemoryManager.class.getName());
    private final Map<Integer, Long> allocatedMap = new HashMap<Integer, Long>();
    private final Map<Integer, Long> reservedMap = new HashMap<Integer, Long>();
    private long available;
    private final StorageProperties storageProperties;

    public DatasetMemoryManager(StorageProperties storageProperties) {
        this.storageProperties = storageProperties;
        this.available = storageProperties.getMemoryComponentGlobalBudget();
    }

    @Override
    public synchronized boolean allocate(int datasetId) {
        if (this.allocatedMap.containsKey(datasetId)) {
            throw new IllegalStateException("Memory is already allocated for dataset: " + datasetId);
        }
        if (this.reservedMap.containsKey(datasetId)) {
            this.allocateReserved(datasetId);
            return true;
        }
        long required = this.getTotalSize(datasetId);
        if (!this.isAllocatable(required)) {
            return false;
        }
        this.allocatedMap.put(datasetId, required);
        this.available -= required;
        LOGGER.info(() -> "Allocated(" + required + ") for dataset(" + datasetId + ")");
        return true;
    }

    @Override
    public synchronized void deallocate(int datasetId) {
        if (!this.allocatedMap.containsKey(datasetId) && !this.reservedMap.containsKey(datasetId)) {
            throw new IllegalStateException("No allocated or reserved memory for dataset: " + datasetId);
        }
        Long allocated = this.allocatedMap.remove(datasetId);
        if (allocated != null && !this.reservedMap.containsKey(datasetId)) {
            this.available += allocated.longValue();
            LOGGER.info(() -> "Deallocated(" + allocated + ") from dataset(" + datasetId + ")");
        }
    }

    @Override
    public synchronized boolean reserve(int datasetId) {
        if (this.reservedMap.containsKey(datasetId)) {
            throw new IllegalStateException("Memory is already reserved for dataset: " + datasetId);
        }
        long required = this.getTotalSize(datasetId);
        if (!this.isAllocatable(required) && !this.allocatedMap.containsKey(datasetId)) {
            return false;
        }
        this.reservedMap.put(datasetId, required);
        if (!this.allocatedMap.containsKey(datasetId)) {
            this.available -= required;
        }
        LOGGER.info(() -> "Reserved(" + required + ") for dataset(" + datasetId + ")");
        return true;
    }

    @Override
    public synchronized void cancelReserved(int datasetId) {
        Long reserved = this.reservedMap.remove(datasetId);
        if (reserved == null) {
            throw new IllegalStateException("No reserved memory for dataset: " + datasetId);
        }
        this.available += reserved.longValue();
        LOGGER.info(() -> "Cancelled reserved(" + reserved + ") from dataset(" + datasetId + ")");
    }

    @Override
    public long getAvailable() {
        return this.available;
    }

    @Override
    public int getNumPages(int datasetId) {
        return MetadataIndexImmutableProperties.isMetadataDataset(datasetId) ? this.storageProperties.getMetadataMemoryComponentNumPages() : this.storageProperties.getMemoryComponentNumPages();
    }

    private long getTotalSize(int datasetId) {
        return (long)this.storageProperties.getMemoryComponentPageSize() * (long)this.getNumPages(datasetId);
    }

    private boolean isAllocatable(long required) {
        return this.available - required >= 0L;
    }

    private void allocateReserved(int datasetId) {
        Long reserved = this.reservedMap.get(datasetId);
        this.allocatedMap.put(datasetId, reserved);
    }
}

