/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.Info;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;

public class DatasetInfo
extends Info
implements Comparable<DatasetInfo> {
    private static final Logger LOGGER = Logger.getLogger(DatasetInfo.class.getName());
    private final Map<Long, IndexInfo> indexes = new HashMap<Long, IndexInfo>();
    private final int datasetID;
    private int numActiveIOOps;
    private long lastAccess;
    private boolean isExternal;
    private boolean isRegistered;
    private boolean memoryAllocated;
    private boolean durable;

    public DatasetInfo(int datasetID) {
        this.setLastAccess(-1L);
        this.datasetID = datasetID;
        this.setRegistered(false);
        this.setMemoryAllocated(false);
    }

    @Override
    public void touch() {
        super.touch();
        this.setLastAccess(System.currentTimeMillis());
    }

    @Override
    public void untouch() {
        super.untouch();
        this.setLastAccess(System.currentTimeMillis());
    }

    public synchronized void declareActiveIOOperation() {
        ++this.numActiveIOOps;
    }

    public synchronized void undeclareActiveIOOperation() {
        --this.numActiveIOOps;
        this.notifyAll();
    }

    public synchronized Set<ILSMIndex> getDatasetIndexes() {
        HashSet<ILSMIndex> datasetIndexes = new HashSet<ILSMIndex>();
        for (IndexInfo iInfo : this.getIndexes().values()) {
            if (!iInfo.isOpen()) continue;
            datasetIndexes.add(iInfo.getIndex());
        }
        return datasetIndexes;
    }

    public synchronized Set<IndexInfo> getDatsetIndexInfos() {
        HashSet<IndexInfo> infos = new HashSet<IndexInfo>();
        for (IndexInfo iInfo : this.getIndexes().values()) {
            if (!iInfo.isOpen()) continue;
            infos.add(iInfo);
        }
        return infos;
    }

    @Override
    public int compareTo(DatasetInfo i) {
        if (this.isOpen() && !i.isOpen()) {
            return -1;
        }
        if (!this.isOpen() && i.isOpen()) {
            return 1;
        }
        if (this.getReferenceCount() < i.getReferenceCount()) {
            return -1;
        }
        if (this.getReferenceCount() > i.getReferenceCount()) {
            return 1;
        }
        if (this.getLastAccess() < i.getLastAccess()) {
            return -1;
        }
        if (this.getLastAccess() > i.getLastAccess()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatasetInfo) {
            return this.datasetID == ((DatasetInfo)obj).datasetID;
        }
        return false;
    }

    public int hashCode() {
        return this.datasetID;
    }

    public String toString() {
        return "DatasetID: " + this.getDatasetID() + ", isOpen: " + this.isOpen() + ", refCount: " + this.getReferenceCount() + ", lastAccess: " + this.getLastAccess() + ", isRegistered: " + this.isRegistered() + ", memoryAllocated: " + this.isMemoryAllocated() + ", isDurable: " + this.isDurable();
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public Map<Long, IndexInfo> getIndexes() {
        return this.indexes;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public int getDatasetID() {
        return this.datasetID;
    }

    public boolean isMemoryAllocated() {
        return this.memoryAllocated;
    }

    public void setMemoryAllocated(boolean memoryAllocated) {
        this.memoryAllocated = memoryAllocated;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public synchronized void waitForIO() throws HyracksDataException {
        while (this.numActiveIOOps > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (this.numActiveIOOps < 0) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Number of IO operations cannot be negative for dataset: " + this);
            }
            throw new IllegalStateException("Number of IO operations cannot be negative");
        }
    }
}

