/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class GlobalConfig {
    public static final boolean DEBUG = true;
    public static final String ASTERIX_LOGGER_NAME = "org.apache.asterix";
    public static final Logger ASTERIX_LOGGER = Logger.getLogger("org.apache.asterix");
    public static final String DEFAULT_CONFIG_FILE_NAME = "asterix-configuration.xml";
    public static final String CONFIG_FILE_PROPERTY = "AsterixConfigFileName";
    public static final int DEFAULT_FRAME_SIZE = 32768;
    public static final String FRAME_SIZE_PROPERTY = "FrameSize";
    public static final float DEFAULT_TREE_FILL_FACTOR = 1.0f;
    public static int DEFAULT_INPUT_DATA_COLUMN = 0;
    public static final String DEFAULT_COMPACTION_POLICY_NAME = "prefix";
    public static final String DEFAULT_FILTERED_DATASET_COMPACTION_POLICY_NAME = "correlated-prefix";
    public static final Map<String, String> DEFAULT_COMPACTION_POLICY_PROPERTIES = new LinkedHashMap<String, String>();

    public static int getFrameSize() {
        int frameSize = 32768;
        String frameSizeStr = System.getProperty(FRAME_SIZE_PROPERTY);
        if (frameSizeStr != null) {
            int fz = -1;
            try {
                fz = Integer.parseInt(frameSizeStr);
            }
            catch (NumberFormatException nfe) {
                ASTERIX_LOGGER.warning("Wrong frame size size argument. Picking default value (32768) instead.\n");
            }
            if (fz >= 0) {
                frameSize = fz;
            }
        }
        return frameSize;
    }

    static {
        DEFAULT_COMPACTION_POLICY_PROPERTIES.put("max-mergable-component-size", "1073741824");
        DEFAULT_COMPACTION_POLICY_PROPERTIES.put("max-tolerance-component-count", "5");
    }
}

