/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.api;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public enum Duration {
    SEC("s", 9),
    MILLI("ms", 6),
    MICRO("\u00b5s", 3),
    NANO("ns", 0);

    static final long NANOSECONDS = 1L;
    static final long MICROSECONDS = 1000L;
    static final long MILLISECONDS = 1000000L;
    static final long SECONDS = 1000000000L;
    static final long MINUTES = 60000000000L;
    static final long HOURS = 3600000000000L;
    String unit;
    int nanoDigits;

    private Duration(String unit, int nanoDigits) {
        this.unit = unit;
        this.nanoDigits = nanoDigits;
    }

    public static String formatNanos(long nanoTime) {
        String strTime = String.valueOf(nanoTime);
        int len = strTime.length();
        for (Duration tu : Duration.values()) {
            if (len <= tu.nanoDigits) continue;
            String integer = strTime.substring(0, len - tu.nanoDigits);
            String fractional = strTime.substring(len - tu.nanoDigits);
            return integer + (fractional.length() > 0 ? "." + fractional : "") + tu.unit;
        }
        return "illegal string value: " + strTime;
    }

    public static long parseDurationStringToNanos(String orig) throws HyracksDataException {
        char c;
        String s = orig;
        long d = 0L;
        boolean neg = false;
        if (!(s.isEmpty() || (c = s.charAt(0)) != '-' && c != '+')) {
            neg = c == '-';
            s = s.substring(1);
        }
        if ("0".equals(s)) {
            return 0L;
        }
        if (s.isEmpty()) {
            throw new RuntimeDataException(28, new Serializable[]{orig});
        }
        while (!s.isEmpty()) {
            int i;
            long v = 0L;
            long f = 0L;
            double scale = 1.0;
            if (s.charAt(0) != '.' && ('0' > s.charAt(0) || s.charAt(0) > '9')) {
                throw new RuntimeDataException(28, new Serializable[]{orig});
            }
            int pl = s.length();
            Pair<Long, String> pair = Duration.leadingInt(s);
            v = (Long)pair.getLeft();
            s = (String)pair.getRight();
            boolean pre = pl != s.length();
            boolean post = false;
            if (!s.isEmpty() && s.charAt(0) == '.') {
                s = s.substring(1);
                pl = s.length();
                Triple<Long, Double, String> triple = Duration.leadingFraction(s);
                f = (Long)triple.getLeft();
                scale = (Double)triple.getMiddle();
                s = (String)triple.getRight();
                boolean bl = post = pl != s.length();
            }
            if (!pre && !post) {
                throw new RuntimeDataException(28, new Serializable[]{orig});
            }
            for (i = 0; i < s.length() && (c = s.charAt(i)) != '.' && ('0' > c || c > '9'); ++i) {
            }
            if (i == 0) {
                throw new RuntimeDataException(28, new Serializable[]{orig});
            }
            String u = s.substring(0, i);
            s = s.substring(i);
            long unit = Duration.getUnit(u);
            if (v > Long.MAX_VALUE / unit) {
                throw new RuntimeDataException(28, new Serializable[]{orig});
            }
            v *= unit;
            if (f > 0L && (v += (long)((double)f * (double)unit / scale)) < 0L) {
                throw new RuntimeDataException(28, new Serializable[]{orig});
            }
            if ((d += v) >= 0L) continue;
            throw new RuntimeDataException(28, new Serializable[]{orig});
        }
        if (neg) {
            d = -d;
        }
        return d;
    }

    private static final long getUnit(String unit) throws HyracksDataException {
        switch (unit) {
            case "ns": {
                return 1L;
            }
            case "us": 
            case "\u00b5s": 
            case "\u03bcs": {
                return 1000L;
            }
            case "ms": {
                return 1000000L;
            }
            case "s": {
                return 1000000000L;
            }
            case "m": {
                return 60000000000L;
            }
            case "h": {
                return 3600000000000L;
            }
        }
        throw new RuntimeDataException(29, new Serializable[]{unit});
    }

    static Pair<Long, String> leadingInt(String origin) throws HyracksDataException {
        char c;
        int i;
        String s = origin;
        long x = 0L;
        for (i = 0; i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
            if (x > 0xCCCCCCCCCCCCCCCL) {
                throw new RuntimeDataException(28, new Serializable[]{origin});
            }
            if ((x = x * 10L + (long)Character.getNumericValue(c)) >= 0L) continue;
            throw new RuntimeDataException(28, new Serializable[]{origin});
        }
        return Pair.of((Object)x, (Object)s.substring(i));
    }

    static Triple<Long, Double, String> leadingFraction(String s) {
        char c;
        int i;
        long x = 0L;
        double scale = 1.0;
        boolean overflow = false;
        for (i = 0; i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
            if (overflow) continue;
            if (x > 0x6666666L) {
                overflow = true;
                continue;
            }
            long y = x * 10L + (long)Character.getNumericValue(c);
            if (y < 0L) {
                overflow = true;
                continue;
            }
            x = y;
            scale *= 10.0;
        }
        return Triple.of((Object)x, (Object)scale, (Object)s.substring(i));
    }
}

