/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.List;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.BackupInfo;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.RestoreConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class RestoreCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((RestoreConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        int backupId = ((RestoreConfig)this.config).backupId;
        List backupInfoList = instance.getBackupInfo();
        if (backupInfoList.size() <= backupId || backupId < 0) {
            throw new IllegalStateException("Invalid backup id");
        }
        BackupInfo backupInfo = (BackupInfo)backupInfoList.get(backupId);
        Patterns patterns = PatternCreator.INSTANCE.getRestoreAsterixPattern(instance, backupInfo);
        AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster()).submit(patterns);
        LOGGER.info((Object)("Asterix instance: " + asterixInstanceName + " has been restored from backup"));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new RestoreConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nRestores an ASTERIX instance's data from a previously taken backup snapshot.\n\nAvailable arguments/options\n-n name of the ASTERIX instance\n-b id of the backup snapshot ";
    }
}

