/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.List;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.DescribeConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.error.InstallerException;

public class DescribeCommand
extends AbstractCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((DescribeConfig)this.config).name;
        boolean adminView = ((DescribeConfig)this.config).admin;
        if (asterixInstanceName != null) {
            AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE, AsterixInstance.State.ACTIVE, AsterixInstance.State.UNUSABLE});
            AsterixInstance instance = ServiceProvider.INSTANCE.getLookupService().getAsterixInstance(asterixInstanceName);
            if (instance == null) throw new InstallerException("Asterix instance by the name " + asterixInstanceName + " does not exist.");
            AsterixRuntimeState state = VerificationUtil.getAsterixRuntimeState((AsterixInstance)instance);
            boolean expectedRunning = instance.getState().equals((Object)AsterixInstance.State.UNUSABLE) ? instance.getPreviousState().equals((Object)AsterixInstance.State.ACTIVE) : !instance.getState().equals((Object)AsterixInstance.State.INACTIVE);
            VerificationUtil.updateInstanceWithRuntimeDescription((AsterixInstance)instance, (AsterixRuntimeState)state, (boolean)expectedRunning);
            ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(instance);
            LOGGER.info((Object)instance.getDescription(adminView));
            return;
        } else {
            List asterixInstances = ServiceProvider.INSTANCE.getLookupService().getAsterixInstances();
            if (asterixInstances.size() > 0) {
                for (AsterixInstance instance : asterixInstances) {
                    AsterixRuntimeState state = VerificationUtil.getAsterixRuntimeState((AsterixInstance)instance);
                    boolean expectedRunning = instance.getState().equals((Object)AsterixInstance.State.UNUSABLE) ? instance.getPreviousState().equals((Object)AsterixInstance.State.ACTIVE) : !instance.getState().equals((Object)AsterixInstance.State.INACTIVE);
                    VerificationUtil.updateInstanceWithRuntimeDescription((AsterixInstance)instance, (AsterixRuntimeState)state, (boolean)expectedRunning);
                    ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(instance);
                    LOGGER.info((Object)instance.getDescription(adminView));
                }
                return;
            } else {
                LOGGER.info((Object)"No Asterix instances found!");
            }
        }
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new DescribeConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nProvides information about an ASTERIX instance.\n\nUsage arguments/options:-\n[-n]       Name of the ASTERIX instance.\n[-admin]   Provides a detailed description";
    }
}

