/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.Date;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ILookupService;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.AlterConfig;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.driver.InstallerUtil;

public class AlterCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String instanceName = ((AlterConfig)this.config).name;
        AsterixEventServiceUtil.validateAsterixInstanceExists((String)instanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        ILookupService lookupService = ServiceProvider.INSTANCE.getLookupService();
        AsterixInstance instance = ServiceProvider.INSTANCE.getLookupService().getAsterixInstance(instanceName);
        AsterixEventServiceUtil.createClusterProperties((Cluster)instance.getCluster(), (AsterixConfiguration)instance.getAsterixConfiguration());
        AsterixConfiguration asterixConfiguration = InstallerUtil.getAsterixConfiguration(((AlterConfig)this.config).confPath);
        instance.setAsterixConfiguration(asterixConfiguration);
        instance.setModifiedTimestamp(new Date());
        lookupService.updateAsterixInstance(instance);
        LOGGER.info((Object)("Altered configuration settings for Asterix instance: " + instanceName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new AlterConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nAlter the instance's configuration settings.\nPrior to running this command, the instance is required to be INACTIVE state.\nChanged configuration settings will be reflected when the instance is started.\n\nAvailable arguments/options\n-n name of the ASTERIX instance.";
    }
}

