/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.nio.ByteBuffer;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class TransactionUtil {
    private TransactionUtil() {
    }

    public static void formJobTerminateLogRecord(ITransactionContext txnCtx, LogRecord logRecord, boolean isCommit) {
        logRecord.setTxnCtx(txnCtx);
        TransactionUtil.formJobTerminateLogRecord(logRecord, txnCtx.getJobId().getId(), isCommit);
    }

    public static void formJobTerminateLogRecord(LogRecord logRecord, int jobId, boolean isCommit) {
        logRecord.setLogType(isCommit ? (byte)1 : 3);
        logRecord.setDatasetId(-1);
        logRecord.setPKHashValue(-1);
        logRecord.setJobId(jobId);
        logRecord.computeAndSetLogSize();
    }

    public static void formFlushLogRecord(LogRecord logRecord, int datasetId, PrimaryIndexOperationTracker opTracker, String nodeId, int numberOfIndexes) {
        logRecord.setLogType((byte)4);
        logRecord.setJobId(-1);
        logRecord.setDatasetId(datasetId);
        logRecord.setOpTracker(opTracker);
        logRecord.setNumOfFlushedIndexes(numberOfIndexes);
        logRecord.setNodeId(nodeId);
        logRecord.computeAndSetLogSize();
    }

    public static void formEntityCommitLogRecord(LogRecord logRecord, ITransactionContext txnCtx, int datasetId, int PKHashValue, ITupleReference PKValue, int[] PKFields, int resourcePartition, byte entityCommitType) {
        logRecord.setTxnCtx(txnCtx);
        logRecord.setLogType(entityCommitType);
        logRecord.setJobId(txnCtx.getJobId().getId());
        logRecord.setDatasetId(datasetId);
        logRecord.setPKHashValue(PKHashValue);
        logRecord.setPKFieldCnt(PKFields.length);
        logRecord.setPKValue(PKValue);
        logRecord.setPKFields(PKFields);
        logRecord.setResourcePartition(resourcePartition);
        logRecord.computeAndSetPKValueSize();
        logRecord.computeAndSetLogSize();
    }

    public static void formMarkerLogRecord(LogRecord logRecord, ITransactionContext txnCtx, int datasetId, int resourcePartition, ByteBuffer marker) {
        logRecord.setTxnCtx(txnCtx);
        logRecord.setLogSource((byte)0);
        logRecord.setLogType((byte)7);
        logRecord.setJobId(txnCtx.getJobId().getId());
        logRecord.setDatasetId(datasetId);
        logRecord.setResourcePartition(resourcePartition);
        marker.get();
        logRecord.setMarker(marker);
        logRecord.computeAndSetLogSize();
    }
}

