/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

public class InterruptUtil {
    public static void doUninterruptibly(Interruptible interruptible) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    interruptible.run();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void doExUninterruptibly(ThrowingInterruptible interruptible) throws Exception {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    interruptible.run();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean doUninterruptiblyGet(Interruptible interruptible) {
        boolean interrupted = false;
        while (true) {
            try {
                interruptible.run();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doExUninterruptiblyGet(ThrowingInterruptible interruptible) throws Exception {
        boolean interrupted = false;
        boolean success = false;
        while (true) {
            try {
                interruptible.run();
                success = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (success || !interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return interrupted;
    }

    @FunctionalInterface
    public static interface ThrowingInterruptible {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface Interruptible {
        public void run() throws InterruptedException;
    }
}

