/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicy;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class CorrelatedPrefixMergePolicy
extends PrefixMergePolicy {
    private final IDatasetLifecycleManager datasetLifecycleManager;
    private final int datasetId;

    public CorrelatedPrefixMergePolicy(IDatasetLifecycleManager datasetLifecycleManager, int datasetId) {
        this.datasetLifecycleManager = datasetLifecycleManager;
        this.datasetId = datasetId;
    }

    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        if (fullMergeIsRequested || index.isPrimaryIndex()) {
            super.diskComponentAdded(index, fullMergeIsRequested);
        }
    }

    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        if (index.isPrimaryIndex()) {
            return super.isMergeLagging(index);
        }
        return false;
    }

    protected boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        ArrayList immutableComponents = new ArrayList(index.getDiskComponents());
        Collections.reverse(immutableComponents);
        Pair mergeableIndexes = this.getMergableComponentsIndex(immutableComponents);
        if (mergeableIndexes == null) {
            return false;
        }
        long minID = ((ILSMDiskComponent)immutableComponents.get((Integer)mergeableIndexes.getLeft())).getComponentId().getMinId();
        long maxID = ((ILSMDiskComponent)immutableComponents.get((Integer)mergeableIndexes.getRight())).getComponentId().getMaxId();
        Set<IndexInfo> indexInfos = this.datasetLifecycleManager.getDatasetInfo(this.datasetId).getDatsetIndexInfos();
        int partition = this.getIndexPartition(index, indexInfos);
        this.triggerScheduledMerge(minID, maxID, indexInfos.stream().filter(info -> info.getPartition() == partition).collect(Collectors.toSet()));
        return true;
    }

    private void triggerScheduledMerge(long minID, long maxID, Set<IndexInfo> indexInfos) throws HyracksDataException {
        for (IndexInfo info : indexInfos) {
            ILSMIndex lsmIndex = info.getIndex();
            ArrayList immutableComponents = new ArrayList(lsmIndex.getDiskComponents());
            if (this.isMergeOngoing(immutableComponents)) continue;
            ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>();
            for (ILSMDiskComponent component : immutableComponents) {
                ILSMDiskComponentId id = component.getComponentId();
                if (id.getMinId() >= minID && id.getMaxId() <= maxID) {
                    mergableComponents.add(component);
                }
                if (id.getMaxId() >= minID) continue;
                break;
            }
            ILSMIndexAccessor accessor = lsmIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleMerge(lsmIndex.getIOOperationCallback(), mergableComponents);
        }
    }

    private int getIndexPartition(ILSMIndex index, Set<IndexInfo> indexInfos) {
        for (IndexInfo info : indexInfos) {
            if (info.getIndex() != index) continue;
            return info.getPartition();
        }
        return -1;
    }
}

