/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class ReplicationProperties
extends AbstractProperties {
    private static final int REPLICATION_DATAPORT_DEFAULT = 2000;
    private static final int REPLICATION_TIME_OUT_DEFAULT = 15;
    private static final String NODE_IP_ADDRESS_DEFAULT = "127.0.0.1";
    private final IReplicationStrategy repStrategy = ClusterProperties.INSTANCE.getReplicationStrategy();

    public ReplicationProperties(PropertiesAccessor accessor) throws HyracksDataException {
        super(accessor);
    }

    public int getMaxRemoteRecoveryAttempts() {
        return this.accessor.getInt(Option.REPLICATION_MAX_REMOTE_RECOVERY_ATTEMPTS);
    }

    public int getLogBufferPageSize() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BUFFER_PAGESIZE);
    }

    public int getLogBufferNumOfPages() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BUFFER_NUMPAGES);
    }

    public int getLogBatchSize() {
        return this.accessor.getInt(Option.REPLICATION_LOG_BATCHSIZE);
    }

    public String getReplicaIPAddress(String nodeId) {
        Node node = ClusterProperties.INSTANCE.getNodeById(nodeId);
        return node != null ? node.getClusterIp() : NODE_IP_ADDRESS_DEFAULT;
    }

    public int getDataReplicationPort(String nodeId) {
        Cluster cluster = ClusterProperties.INSTANCE.getCluster();
        Node node = ClusterProperties.INSTANCE.getNodeById(nodeId);
        if (node != null) {
            return node.getReplicationPort() != null ? node.getReplicationPort().intValue() : cluster.getHighAvailability().getDataReplication().getReplicationPort().intValue();
        }
        return 2000;
    }

    public Replica getReplicaById(String nodeId) {
        Node node = ClusterProperties.INSTANCE.getNodeById(nodeId);
        if (node != null) {
            return new Replica(node);
        }
        return null;
    }

    public Set<String> getRemoteReplicasIds(String nodeId) {
        return this.repStrategy.getRemoteReplicas(nodeId).stream().map(Replica::getId).collect(Collectors.toSet());
    }

    public Set<String> getRemotePrimaryReplicasIds(String nodeId) {
        return this.repStrategy.getRemotePrimaryReplicas(nodeId).stream().map(Replica::getId).collect(Collectors.toSet());
    }

    public Set<String> getNodeReplicasIds(String nodeId) {
        Set<String> remoteReplicasIds = this.getRemoteReplicasIds(nodeId);
        remoteReplicasIds.add(nodeId);
        return remoteReplicasIds;
    }

    public int getReplicationTimeOut() {
        return this.accessor.getInt(Option.REPLICATION_TIMEOUT);
    }

    public boolean isParticipant(String nodeId) {
        return this.repStrategy.isParticipant(nodeId);
    }

    public IReplicationStrategy getReplicationStrategy() {
        return this.repStrategy;
    }

    public static enum Option implements IOption
    {
        REPLICATION_MAX_REMOTE_RECOVERY_ATTEMPTS(OptionTypes.INTEGER, 5, "The maximum number of times to attempt to recover from a replica on failure before giving up"),
        REPLICATION_LOG_BUFFER_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The size in bytes of each log buffer page"),
        REPLICATION_LOG_BUFFER_NUMPAGES(OptionTypes.INTEGER, 8, "The number of log buffer pages"),
        REPLICATION_LOG_BATCHSIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE), "The size in bytes to replicate in each batch"),
        REPLICATION_TIMEOUT(OptionTypes.INTEGER, 15, "The time in seconds to timeout when trying to contact a replica, before assuming it is dead");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public Object get(IApplicationConfig config) {
            switch (this) {
                case REPLICATION_TIMEOUT: {
                    Cluster cluster = ClusterProperties.INSTANCE.getCluster();
                    if (cluster != null && cluster.getHighAvailability() != null && cluster.getHighAvailability().getDataReplication() != null && cluster.getHighAvailability().getDataReplication().getReplicationTimeOut() != null) {
                        return cluster.getHighAvailability().getDataReplication().getReplicationTimeOut().intValue();
                    }
                    return 15;
                }
            }
            return config.getStatic((IOption)this);
        }
    }
}

