/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.model;

import java.io.Serializable;
import java.util.Date;
import org.apache.asterix.installer.schema.conf.Backup;
import org.apache.asterix.installer.schema.conf.Hdfs;

public class BackupInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final Date date;
    private final Backup backupConf;

    public BackupInfo(int id, Date date, Backup backupConf) {
        this.id = id;
        this.date = date;
        this.backupConf = backupConf;
    }

    public int getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public Backup getBackupConf() {
        return this.backupConf;
    }

    public String toString() {
        return this.id + " " + this.date + " (" + (Object)((Object)this.getBackupType()) + ") [ " + this.getBackupConf().getBackupDir() + " ]";
    }

    public BackupType getBackupType() {
        return BackupInfo.getBackupType(this.getBackupConf());
    }

    public static BackupType getBackupType(Backup backupConf) {
        Hdfs hdfs = backupConf.getHdfs();
        return hdfs != null && hdfs.getUrl() != null && hdfs.getUrl().length() > 0 ? BackupType.HDFS : BackupType.LOCAL;
    }

    public static enum BackupType {
        LOCAL,
        HDFS;

    }
}

