/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.management;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.management.EventExecutor;
import org.apache.asterix.event.management.EventTaskReport;
import org.apache.asterix.event.management.EventUtil;
import org.apache.asterix.event.management.ValueType;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.event.Event;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Period;
import org.apache.log4j.Logger;

public class EventTask
extends TimerTask {
    private static final Logger logger = Logger.getLogger((String)EventTask.class.getName());
    private Pattern pattern;
    private Event event;
    private long interval = 0L;
    private long initialDelay = 0L;
    private int maxOccurs = Integer.MAX_VALUE;
    private int occurrenceCount = 0;
    private Timer timer;
    private String taskScript;
    private Node location;
    private List<String> taskArgs;
    private AsterixEventServiceClient client;
    private List<Node> candidateLocations;
    private boolean dynamicLocation = false;
    private boolean reuseLocation = false;
    private State state;

    public EventTask(Pattern pattern, AsterixEventServiceClient client) {
        this.pattern = pattern;
        this.client = client;
        Period period = pattern.getPeriod();
        if (period != null && period.getAbsvalue() != null) {
            this.interval = EventUtil.parseTimeInterval(period.getAbsvalue(), period.getUnit());
        }
        if (pattern.getDelay() != null) {
            this.initialDelay = EventUtil.parseTimeInterval(new ValueType(pattern.getDelay().getValue()), pattern.getDelay().getUnit());
        }
        if (pattern.getMaxOccurs() != null) {
            this.maxOccurs = pattern.getMaxOccurs();
        }
        this.timer = new Timer();
        this.taskArgs = EventUtil.getEventArgs(pattern);
        this.candidateLocations = EventUtil.getCandidateLocations(pattern, client.getCluster());
        if (pattern.getEvent().getNodeid().getValue().getRandom() != null && period != null && this.maxOccurs > 1) {
            this.dynamicLocation = true;
            this.reuseLocation = pattern.getEvent().getNodeid().getValue().getRandom().getRange().isReuse();
        } else {
            this.location = EventUtil.getEventLocation(pattern, this.candidateLocations, client.getCluster());
        }
        String scriptsDir = this.location.getId().equals("client_node") ? client.getEventsDir() : client.getCluster().getWorkingDir().getDir() + File.separator + "events";
        this.event = EventUtil.getEvent(pattern, client.getEvents());
        this.taskScript = scriptsDir + File.separator + this.event.getScript();
        this.state = State.INITIALIZED;
    }

    public void start() {
        if (this.interval > 0L) {
            this.timer.schedule((TimerTask)this, this.initialDelay, this.interval);
        } else {
            this.timer.schedule((TimerTask)this, this.initialDelay);
        }
    }

    @Override
    public void run() {
        if (this.candidateLocations.size() == 0) {
            this.timer.cancel();
            this.client.notifyCompletion(new EventTaskReport(this));
        } else {
            if (this.dynamicLocation) {
                this.location = EventUtil.getEventLocation(this.pattern, this.candidateLocations, this.client.getCluster());
                if (!this.reuseLocation) {
                    this.candidateLocations.remove(this.location);
                }
            }
            logger.debug((Object)(EventUtil.dateFormat.get().format(new Date()) + " EVENT " + this.pattern.getEvent().getType().toUpperCase() + " at " + this.location.getId().toUpperCase()));
            try {
                if (!this.client.isDryRun()) {
                    new EventExecutor().executeEvent(this.location, this.taskScript, this.taskArgs, this.event.isDaemon(), this.client.getCluster(), this.pattern, this.client.getErrorHandler(), this.client);
                }
                ++this.occurrenceCount;
                if (this.occurrenceCount >= this.maxOccurs) {
                    this.timer.cancel();
                    this.client.notifyCompletion(new EventTaskReport(this));
                }
            }
            catch (IOException ioe) {
                this.timer.cancel();
                this.client.notifyCompletion(new EventTaskReport(this, false, ioe));
            }
        }
    }

    public Node getLocation() {
        return this.location;
    }

    public long getInterval() {
        return this.interval;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INITIALIZED,
        IN_PROGRESS,
        COMPLETED,
        FAILED;

    }
}

