/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class CorrelatedPrefixMergePolicy
implements ILSMMergePolicy {
    private long maxMergableComponentSize;
    private int maxToleranceComponentCount;
    private final IDatasetLifecycleManager datasetLifecycleManager;
    private final int datasetId;

    public CorrelatedPrefixMergePolicy(IDatasetLifecycleManager datasetLifecycleManager, int datasetId) {
        this.datasetLifecycleManager = datasetLifecycleManager;
        this.datasetId = datasetId;
    }

    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        if (fullMergeIsRequested) {
            ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getImmutableComponents());
            if (!this.areComponentsReadableUnwritableState(immutableComponents)) {
                return;
            }
            ILSMIndexAccessor accessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFullMerge(index.getIOOperationCallback());
            return;
        }
        if (!index.isPrimaryIndex()) {
            return;
        }
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getImmutableComponents());
        if (!this.areComponentsReadableUnwritableState(immutableComponents)) {
            return;
        }
        this.scheduleMerge(index);
    }

    public void configure(Map<String, String> properties) {
        this.maxMergableComponentSize = Long.parseLong(properties.get("max-mergable-component-size"));
        this.maxToleranceComponentCount = Integer.parseInt(properties.get("max-tolerance-component-count"));
    }

    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        List immutableComponents = index.getImmutableComponents();
        int mergableImmutableComponentCount = this.getMergableImmutableComponentCount(immutableComponents);
        if (mergableImmutableComponentCount < this.maxToleranceComponentCount) {
            return false;
        }
        boolean isMergeOngoing = this.isMergeOngoing(immutableComponents);
        if (isMergeOngoing) {
            return true;
        }
        if (index.isPrimaryIndex()) {
            if (!this.areComponentsReadableUnwritableState(immutableComponents)) {
                throw new IllegalStateException();
            }
            boolean isMergeTriggered = this.scheduleMerge(index);
            if (!isMergeTriggered) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    private boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        ArrayList immutableComponents = new ArrayList(index.getImmutableComponents());
        Collections.reverse(immutableComponents);
        long totalSize = 0L;
        int startIndex = -1;
        int numComponents = immutableComponents.size();
        for (int i = 0; i < numComponents; ++i) {
            boolean isLastComponent;
            ILSMComponent c = (ILSMComponent)immutableComponents.get(i);
            long componentSize = ((ILSMDiskComponent)c).getComponentSize();
            if (componentSize > this.maxMergableComponentSize || ((ILSMDiskComponent)c).getComponentId().notFound()) {
                startIndex = i;
                totalSize = 0L;
                continue;
            }
            boolean bl = isLastComponent = i + 1 == numComponents;
            if ((totalSize += componentSize) <= this.maxMergableComponentSize && (!isLastComponent || i - startIndex < this.maxToleranceComponentCount)) continue;
            long minID = Long.MAX_VALUE;
            long maxID = Long.MIN_VALUE;
            for (int j = startIndex + 1; j <= i; ++j) {
                ILSMDiskComponentId id = ((ILSMDiskComponent)immutableComponents.get(j)).getComponentId();
                if (minID > id.getMinId()) {
                    minID = id.getMinId();
                }
                if (maxID >= id.getMaxId()) continue;
                maxID = id.getMaxId();
            }
            Set<IndexInfo> indexInfos = this.datasetLifecycleManager.getDatasetInfo(this.datasetId).getDatsetIndexInfos();
            int partition = this.getIndexPartition(index, indexInfos);
            this.triggerScheduledMerge(minID, maxID, indexInfos.stream().filter(info -> info.getPartition() == partition).collect(Collectors.toSet()));
            return true;
        }
        return false;
    }

    private void triggerScheduledMerge(long minID, long maxID, Set<IndexInfo> indexInfos) throws HyracksDataException {
        for (IndexInfo info : indexInfos) {
            ILSMIndex lsmIndex = info.getIndex();
            ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(lsmIndex.getImmutableComponents());
            if (this.isMergeOngoing(immutableComponents)) continue;
            ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>();
            for (ILSMDiskComponent component : immutableComponents) {
                ILSMDiskComponentId id = component.getComponentId();
                if (id.notFound()) continue;
                if (id.getMinId() >= minID && id.getMaxId() <= maxID) {
                    mergableComponents.add(component);
                }
                if (id.getMaxId() >= minID) continue;
                break;
            }
            ILSMIndexAccessor accessor = lsmIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleMerge(lsmIndex.getIOOperationCallback(), mergableComponents);
        }
    }

    private int getMergableImmutableComponentCount(List<ILSMDiskComponent> immutableComponents) throws HyracksDataException {
        int count = 0;
        for (ILSMComponent iLSMComponent : immutableComponents) {
            long componentSize = ((ILSMDiskComponent)iLSMComponent).getComponentSize();
            if (iLSMComponent.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE || componentSize > this.maxMergableComponentSize || ((ILSMDiskComponent)iLSMComponent).getComponentId().notFound()) break;
            ++count;
        }
        return count;
    }

    private boolean isMergeOngoing(List<ILSMDiskComponent> immutableComponents) {
        int size = immutableComponents.size();
        for (int i = 0; i < size; ++i) {
            if (immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }

    private boolean areComponentsReadableUnwritableState(List<ILSMDiskComponent> immutableComponents) {
        for (ILSMComponent iLSMComponent : immutableComponents) {
            if (iLSMComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return false;
        }
        return true;
    }

    private int getIndexPartition(ILSMIndex index, Set<IndexInfo> indexInfos) {
        for (IndexInfo info : indexInfos) {
            if (info.getIndex() != index) continue;
            return info.getPartition();
        }
        return -1;
    }
}

