/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableGauge;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableGaugeInt
extends MutableGauge {
    private volatile int value;

    MutableGaugeInt(MetricsInfo info, int initValue) {
        super(info);
        this.value = initValue;
    }

    public int value() {
        return this.value;
    }

    @Override
    public synchronized void incr() {
        ++this.value;
        this.setChanged();
    }

    public synchronized void incr(int delta) {
        this.value += delta;
        this.setChanged();
    }

    @Override
    public synchronized void decr() {
        --this.value;
        this.setChanged();
    }

    public synchronized void decr(int delta) {
        this.value -= delta;
        this.setChanged();
    }

    public void set(int value) {
        this.value = value;
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.info(), this.value);
            this.clearChanged();
        }
    }
}

