/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.File;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.log4j.FileAppender;
import org.apache.log4j.spi.LoggingEvent;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ContainerLogAppender
extends FileAppender {
    private String containerLogDir;
    private int maxEvents;
    private Queue<LoggingEvent> tail = null;
    private static final int EVENT_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOptions() {
        ContainerLogAppender containerLogAppender = this;
        synchronized (containerLogAppender) {
            if (this.maxEvents > 0) {
                this.tail = new LinkedList<LoggingEvent>();
            }
            this.setFile(new File(this.containerLogDir, "syslog").toString());
            this.setAppend(true);
            super.activateOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        ContainerLogAppender containerLogAppender = this;
        synchronized (containerLogAppender) {
            if (this.tail == null) {
                super.append(event);
            } else {
                if (this.tail.size() >= this.maxEvents) {
                    this.tail.remove();
                }
                this.tail.add(event);
            }
        }
    }

    public void flush() {
        if (this.qw != null) {
            this.qw.flush();
        }
    }

    public synchronized void close() {
        if (this.tail != null) {
            for (LoggingEvent event : this.tail) {
                super.append(event);
            }
        }
        super.close();
    }

    public String getContainerLogDir() {
        return this.containerLogDir;
    }

    public void setContainerLogDir(String containerLogDir) {
        this.containerLogDir = containerLogDir;
    }

    public long getTotalLogFileSize() {
        return this.maxEvents * 100;
    }

    public void setTotalLogFileSize(long logSize) {
        this.maxEvents = (int)logSize / 100;
    }
}

