/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPCPerformanceCounters;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCConnectionManager;
import org.apache.hyracks.ipc.impl.Message;

public class IPCSystem {
    private static final Logger LOGGER = Logger.getLogger(IPCSystem.class.getName());
    private final IPCConnectionManager cMgr;
    private final IIPCI ipci;
    private final IPayloadSerializerDeserializer serde;
    private final AtomicLong midFactory;
    private final IPCPerformanceCounters perfCounters;

    public IPCSystem(InetSocketAddress socketAddress, IIPCI ipci, IPayloadSerializerDeserializer serde) throws IOException {
        this.cMgr = new IPCConnectionManager(this, socketAddress);
        this.ipci = ipci;
        this.serde = serde;
        this.midFactory = new AtomicLong();
        this.perfCounters = new IPCPerformanceCounters();
    }

    public InetSocketAddress getSocketAddress() {
        return this.cMgr.getAddress();
    }

    public void start() {
        this.cMgr.start();
    }

    public void stop() {
        this.cMgr.stop();
    }

    public IIPCHandle getHandle(InetSocketAddress remoteAddress) throws IPCException {
        return this.getHandle(remoteAddress, 0);
    }

    public IIPCHandle getHandle(InetSocketAddress remoteAddress, int retries) throws IPCException {
        try {
            return this.cMgr.getIPCHandle(remoteAddress, retries);
        }
        catch (IOException e) {
            throw new IPCException(e);
        }
        catch (InterruptedException e) {
            throw new IPCException(e);
        }
    }

    IPayloadSerializerDeserializer getSerializerDeserializer() {
        return this.serde;
    }

    long createMessageId() {
        return this.midFactory.incrementAndGet();
    }

    void deliverIncomingMessage(Message message) {
        long mid = message.getMessageId();
        long rmid = message.getRequestMessageId();
        Object payload = null;
        Exception exception = null;
        if (message.getFlag() == 3) {
            exception = (Exception)message.getPayload();
            LOGGER.log(Level.INFO, "Exception in message " + message.toString());
        } else {
            payload = message.getPayload();
        }
        this.ipci.deliverIncomingMessage(message.getIPCHandle(), mid, rmid, payload, exception);
    }

    IPCConnectionManager getConnectionManager() {
        return this.cMgr;
    }

    public IPCPerformanceCounters getPerformanceCounters() {
        return this.perfCounters;
    }
}

