/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class SubplanRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline pipeline;
    private final RecordDescriptor inputRecordDesc;
    private final IMissingWriterFactory[] missingWriterFactories;

    public SubplanRuntimeFactory(AlgebricksPipeline pipeline, IMissingWriterFactory[] missingWriterFactories, RecordDescriptor inputRecordDesc, int[] projectionList) {
        super(projectionList);
        this.pipeline = pipeline;
        this.missingWriterFactories = missingWriterFactories;
        this.inputRecordDesc = inputRecordDesc;
        if (projectionList != null) {
            throw new NotImplementedException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Subplan { \n");
        for (IPushRuntimeFactory f : this.pipeline.getRuntimeFactories()) {
            sb.append("  " + f.toString() + ";\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        RecordDescriptor pipelineOutputRecordDescriptor = null;
        final PipelineAssembler pa = new PipelineAssembler(this.pipeline, 1, 1, this.inputRecordDesc, pipelineOutputRecordDescriptor);
        final IMissingWriter[] nullWriters = new IMissingWriter[this.missingWriterFactories.length];
        for (int i = 0; i < this.missingWriterFactories.length; ++i) {
            nullWriters[i] = this.missingWriterFactories[i].createMissingWriter();
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            IFrameWriter endPipe = new TupleOuterProduct();
            NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime startOfPipeline = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)pa.assemblePipeline(this.endPipe, ctx);
            boolean first = true;

            public void open() throws HyracksDataException {
                this.writer.open();
                if (this.first) {
                    this.first = false;
                    this.initAccessAppendRef(ctx);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.startOfPipeline.writeTuple(buffer, t);
                    try {
                        this.startOfPipeline.open();
                        continue;
                    }
                    catch (Exception e) {
                        this.startOfPipeline.fail();
                        throw e;
                    }
                    finally {
                        this.startOfPipeline.close();
                    }
                }
            }

            public void flush() throws HyracksDataException {
                this.writer.flush();
            }

            class TupleOuterProduct
            implements IFrameWriter {
                private boolean smthWasWritten = false;
                private FrameTupleAccessor ta;
                private ArrayTupleBuilder tb;

                TupleOuterProduct() {
                    this.ta = new FrameTupleAccessor(SubplanRuntimeFactory.this.pipeline.getRecordDescriptors()[SubplanRuntimeFactory.this.pipeline.getRecordDescriptors().length - 1]);
                    this.tb = new ArrayTupleBuilder(nullWriters.length);
                }

                public void open() throws HyracksDataException {
                    this.smthWasWritten = false;
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.ta.reset(buffer);
                    int nTuple = this.ta.getTupleCount();
                    for (int t = 0; t < nTuple; ++t) {
                        this.appendConcat(tRef.getFrameTupleAccessor(), tRef.getTupleIndex(), (IFrameTupleAccessor)this.ta, t);
                    }
                    this.smthWasWritten = true;
                }

                public void close() throws HyracksDataException {
                    if (!this.smthWasWritten) {
                        this.appendNullsToTuple();
                        this.appendToFrameFromTupleBuilder(this.tb);
                    }
                }

                public void fail() throws HyracksDataException {
                    writer.fail();
                }

                private void appendNullsToTuple() throws HyracksDataException {
                    this.tb.reset();
                    int n0 = tRef.getFieldCount();
                    for (int f = 0; f < n0; ++f) {
                        this.tb.addField(tRef.getFrameTupleAccessor(), tRef.getTupleIndex(), f);
                    }
                    DataOutput dos = this.tb.getDataOutput();
                    for (int i = 0; i < nullWriters.length; ++i) {
                        nullWriters[i].writeMissing(dos);
                        this.tb.addFieldEndOffset();
                    }
                }
            }
        };
    }
}

