/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;

public class AlgebricksMetaOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline pipeline;

    public AlgebricksMetaOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity, IPushRuntimeFactory[] runtimeFactories, RecordDescriptor[] internalRecordDescriptors) {
        super(spec, inputArity, outputArity);
        if (outputArity == 1) {
            this.outRecDescs[0] = internalRecordDescriptors[internalRecordDescriptors.length - 1];
        }
        this.pipeline = new AlgebricksPipeline(runtimeFactories, internalRecordDescriptors);
    }

    public AlgebricksPipeline getPipeline() {
        return this.pipeline;
    }

    public ObjectNode toJSON() {
        ObjectNode json = super.toJSON();
        json.put("micro-operators", Arrays.toString(this.pipeline.getRuntimeFactories()));
        return json;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Asterix { \n");
        for (IPushRuntimeFactory f : this.pipeline.getRuntimeFactories()) {
            sb.append("  " + f.toString() + ";\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        if (this.inputArity == 0) {
            return this.createSourceInputPushRuntime(ctx);
        }
        return this.createOneInputOneOutputPushRuntime(ctx, recordDescProvider);
    }

    private IOperatorNodePushable createSourceInputPushRuntime(final IHyracksTaskContext ctx) {
        return new AbstractUnaryOutputSourceOperatorNodePushable(){

            public void initialize() throws HyracksDataException {
                RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.outRecDescs[0] : null;
                PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, null, pipelineOutputRecordDescriptor);
                try (IFrameWriter startOfPipeline = pa.assemblePipeline(this.writer, ctx);){
                    startOfPipeline.open();
                }
            }
        };
    }

    private IOperatorNodePushable createOneInputOneOutputPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider) {
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private IFrameWriter startOfPipeline;
            private boolean opened = false;

            public void open() throws HyracksDataException {
                if (this.startOfPipeline == null) {
                    RecordDescriptor pipelineOutputRecordDescriptor = AlgebricksMetaOperatorDescriptor.this.outputArity > 0 ? AlgebricksMetaOperatorDescriptor.this.outRecDescs[0] : null;
                    RecordDescriptor pipelineInputRecordDescriptor = recordDescProvider.getInputRecordDescriptor(AlgebricksMetaOperatorDescriptor.this.getActivityId(), 0);
                    PipelineAssembler pa = new PipelineAssembler(AlgebricksMetaOperatorDescriptor.this.pipeline, AlgebricksMetaOperatorDescriptor.this.inputArity, AlgebricksMetaOperatorDescriptor.this.outputArity, pipelineInputRecordDescriptor, pipelineOutputRecordDescriptor);
                    this.startOfPipeline = pa.assemblePipeline(this.writer, ctx);
                }
                this.opened = true;
                this.startOfPipeline.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.startOfPipeline.nextFrame(buffer);
            }

            public void close() throws HyracksDataException {
                if (this.opened) {
                    this.startOfPipeline.close();
                }
            }

            public void fail() throws HyracksDataException {
                if (this.opened) {
                    this.startOfPipeline.fail();
                }
            }

            public void flush() throws HyracksDataException {
                this.startOfPipeline.flush();
            }

            public String toString() {
                return AlgebricksMetaOperatorDescriptor.this.toString();
            }
        };
    }
}

