/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterAwareBTreePointSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMBTreePointSearchCursor
implements ITreeIndexCursor {
    private BTreeRangeSearchCursor[] rangeCursors;
    private final ILSMIndexOperationContext opCtx;
    private ISearchOperationCallback searchCallback;
    private RangePredicate predicate;
    private boolean includeMutableComponent;
    private int numBTrees;
    private BTree.BTreeAccessor[] btreeAccessors;
    private ILSMHarness lsmHarness;
    private boolean nextHasBeenCalled;
    private boolean foundTuple;
    private int foundIn = -1;
    private ITupleReference frameTuple;
    private List<ILSMComponent> operationalComponents;

    public LSMBTreePointSearchCursor(ILSMIndexOperationContext opCtx) {
        this.opCtx = opCtx;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.nextHasBeenCalled) {
            return false;
        }
        if (this.foundTuple) {
            return true;
        }
        boolean reconciled = false;
        for (int i = 0; i < this.numBTrees; ++i) {
            this.btreeAccessors[i].search((IIndexCursor)this.rangeCursors[i], (ISearchPredicate)this.predicate);
            if (this.rangeCursors[i].hasNext()) {
                this.rangeCursors[i].next();
                if (reconciled || this.searchCallback.proceed(this.predicate.getLowKey())) {
                    if (((ILSMTreeTupleReference)this.rangeCursors[i].getTuple()).isAntimatter()) {
                        if (reconciled) {
                            this.searchCallback.cancel(this.predicate.getLowKey());
                        }
                        this.rangeCursors[i].close();
                        return false;
                    }
                    this.frameTuple = this.rangeCursors[i].getTuple();
                    this.foundTuple = true;
                    this.foundIn = i;
                    return true;
                }
                if (i == 0 && this.includeMutableComponent) {
                    this.rangeCursors[i].reset();
                    this.searchCallback.reconcile(this.predicate.getLowKey());
                    reconciled = true;
                    this.btreeAccessors[0].search((IIndexCursor)this.rangeCursors[i], (ISearchPredicate)this.predicate);
                    if (this.rangeCursors[i].hasNext()) {
                        this.rangeCursors[i].next();
                        if (((ILSMTreeTupleReference)this.rangeCursors[i].getTuple()).isAntimatter()) {
                            this.searchCallback.cancel(this.predicate.getLowKey());
                            this.rangeCursors[i].close();
                            return false;
                        }
                        this.frameTuple = this.rangeCursors[i].getTuple();
                        this.foundTuple = true;
                        this.searchCallback.complete(this.predicate.getLowKey());
                        this.foundIn = i;
                        return true;
                    }
                    this.searchCallback.cancel(this.predicate.getLowKey());
                    this.rangeCursors[i].close();
                    continue;
                }
                this.frameTuple = this.rangeCursors[i].getTuple();
                this.searchCallback.reconcile(this.frameTuple);
                this.searchCallback.complete(this.frameTuple);
                this.foundTuple = true;
                this.foundIn = i;
                return true;
            }
            this.rangeCursors[i].close();
        }
        return false;
    }

    public void reset() throws HyracksDataException {
        try {
            if (this.rangeCursors != null) {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].reset();
                }
            }
            this.rangeCursors = null;
            this.nextHasBeenCalled = false;
            this.foundTuple = false;
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        this.predicate = (RangePredicate)lsmInitialState.getSearchPredicate();
        this.numBTrees = this.operationalComponents.size();
        if (this.rangeCursors == null || this.rangeCursors.length != this.numBTrees) {
            this.rangeCursors = new BTreeRangeSearchCursor[this.numBTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[this.numBTrees];
        }
        this.includeMutableComponent = false;
        for (int i = 0; i < this.numBTrees; ++i) {
            BTree btree;
            IBTreeLeafFrame leafFrame;
            ILSMComponent component = this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                if (this.rangeCursors[i] == null || this.rangeCursors[i].isBloomFilterAware()) {
                    leafFrame = (IBTreeLeafFrame)lsmInitialState.getLeafFrameFactory().createFrame();
                    this.rangeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
                } else {
                    this.rangeCursors[i].reset();
                }
                btree = ((LSMBTreeMemoryComponent)component).getBTree();
            } else {
                if (this.rangeCursors[i] != null && this.rangeCursors[i].isBloomFilterAware()) {
                    ((BloomFilterAwareBTreePointSearchCursor)this.rangeCursors[i]).resetBloomFilter(((LSMBTreeDiskComponent)component).getBloomFilter());
                    this.rangeCursors[i].reset();
                } else {
                    leafFrame = (IBTreeLeafFrame)lsmInitialState.getLeafFrameFactory().createFrame();
                    this.rangeCursors[i] = new BloomFilterAwareBTreePointSearchCursor(leafFrame, false, ((LSMBTreeDiskComponent)component).getBloomFilter());
                }
                btree = ((LSMBTreeDiskComponent)component).getBTree();
            }
            if (this.btreeAccessors[i] == null) {
                this.btreeAccessors[i] = (BTree.BTreeAccessor)btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                continue;
            }
            this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        this.nextHasBeenCalled = false;
        this.foundTuple = false;
    }

    public void next() throws HyracksDataException {
        this.nextHasBeenCalled = true;
    }

    public void close() throws HyracksDataException {
        if (this.lsmHarness != null) {
            try {
                for (int i = 0; i < this.rangeCursors.length; ++i) {
                    this.rangeCursors[i].close();
                }
                this.rangeCursors = null;
            }
            finally {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
        this.nextHasBeenCalled = false;
        this.foundTuple = false;
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getFilter() {
        if (this.foundTuple) {
            return this.operationalComponents.get(this.foundIn).getLSMComponentFilter();
        }
        return null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
    }

    public void setFileId(int fileId) {
    }

    public boolean isExclusiveLatchNodes() {
        return false;
    }
}

