/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;

public class LSMBTreeDiskComponent
extends AbstractLSMDiskComponent {
    private final BTree btree;
    private final BloomFilter bloomFilter;

    public LSMBTreeDiskComponent(BTree btree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super((IMetadataPageManager)btree.getPageManager(), filter);
        this.btree = btree;
        this.bloomFilter = bloomFilter;
    }

    public void destroy() throws HyracksDataException {
        this.btree.deactivate();
        this.btree.destroy();
        if (this.bloomFilter != null) {
            this.bloomFilter.deactivate();
            this.bloomFilter.destroy();
        }
    }

    public BTree getBTree() {
        return this.btree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public long getComponentSize() {
        return this.btree.getFileReference().getFile().length() + (this.bloomFilter == null ? 0L : this.bloomFilter.getFileReference().getFile().length());
    }

    public int getFileReferenceCount() {
        return this.btree.getBufferCache().getFileReferenceCount(this.btree.getFileId());
    }
}

