/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IIndexBulkLoader;

public class LSMBTreeBulkLoader
implements IIndexBulkLoader {
    private final LSMBTree lsmIndex;
    private final ILSMDiskComponent component;
    private final IIndexBulkLoader componentBulkLoader;

    public LSMBTreeBulkLoader(LSMBTree lsmIndex, float fillFactor, boolean verifyInput, long numElementsHint) throws HyracksDataException {
        this.lsmIndex = lsmIndex;
        this.component = lsmIndex.createBulkLoadTarget();
        this.componentBulkLoader = lsmIndex.createComponentBulkLoader(this.component, fillFactor, verifyInput, numElementsHint, false, true, true);
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        this.componentBulkLoader.add(tuple);
    }

    public void end() throws HyracksDataException {
        this.componentBulkLoader.end();
        if (this.component.getComponentSize() > 0L) {
            this.lsmIndex.getIOOperationCallback().afterOperation(LSMOperationType.FLUSH, null, this.component);
            this.lsmIndex.getLsmHarness().addBulkLoadedComponent(this.component);
        }
    }

    public void abort() throws HyracksDataException {
        this.componentBulkLoader.end();
    }
}

